/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.read.ListAppender;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.test.log.RecordedLogs;

public class Recorder {
    private final ListAppender<ILoggingEvent> appender = new ListAppender();
    private final List<String> loggers;
    private final Level level;

    public Recorder(String name, org.slf4j.event.Level level, List<String> loggers) {
        this.loggers = loggers;
        this.level = Level.toLevel((String)level.toString());
        this.appender.setName(name);
        ThresholdFilter levelFilter = new ThresholdFilter();
        levelFilter.setLevel(level.toString());
        levelFilter.start();
        this.appender.addFilter((Filter)levelFilter);
    }

    public List<ILoggingEvent> getRecords() {
        return this.appender.list;
    }

    public RecordedLogs getRecordedLogs() {
        return new RecordedLogs(this);
    }

    public void clear() {
        this.appender.list.clear();
    }

    public void attach() {
        boolean rootLevelMatch = this.isRootLevelMatch();
        this.getMatchedLoggers().forEach(logger -> {
            if (!logger.isAttached(this.appender)) {
                logger.addAppender(this.appender);
            }
            if (logger.getLevel() != null && !this.isLevelMatch((Logger)logger) || !rootLevelMatch) {
                logger.setLevel(this.level);
            }
        });
        this.appender.start();
    }

    public void destroy() {
        this.appender.stop();
        this.getMatchedLoggers().forEach(logger -> logger.detachAppender(this.appender));
    }

    private boolean isRootLevelMatch() {
        return this.isLevelMatch((Logger)LoggerFactory.getLogger((String)"ROOT"));
    }

    private boolean isLevelMatch(Logger logger) {
        Level currentLevel = logger.getLevel();
        return currentLevel != null && (currentLevel.equals(this.level) || !currentLevel.isGreaterOrEqual(this.level));
    }

    private List<Logger> getMatchedLoggers() {
        ArrayList<Logger> res = new ArrayList<Logger>();
        if (this.loggers.isEmpty()) {
            res.add((Logger)LoggerFactory.getLogger((String)"ROOT"));
        } else {
            this.loggers.forEach(loggerName -> res.add((Logger)LoggerFactory.getLogger((String)loggerName)));
        }
        return res;
    }
}

