/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.rest;

import io.dropwizard.core.setup.Environment;
import io.dropwizard.core.setup.ExceptionMapperBinder;
import io.dropwizard.jersey.jackson.JacksonFeature;
import io.dropwizard.jersey.validation.HibernateValidationBinder;
import jakarta.servlet.DispatcherType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Predicate;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.context.Disables;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.ResourceInstaller;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycle;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ApplicationRunEvent;
import ru.vyarus.dropwizard.guice.test.rest.RestClient;
import ru.vyarus.dropwizard.guice.test.rest.StubRestConfig;
import ru.vyarus.dropwizard.guice.test.rest.TestContainerPolicy;
import ru.vyarus.dropwizard.guice.test.rest.support.GuiceyJerseyTest;

public class RestStubsHook
implements GuiceyConfigurationHook {
    private final StubRestConfig config;
    private GuiceyJerseyTest jerseyStub;
    private RestClient restClient;

    public RestStubsHook(StubRestConfig config) {
        this.config = config;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void configure(GuiceBundle.Builder builder) throws Exception {
        builder.option(GuiceyOptions.GuiceFilterRegistration, EnumSet.noneOf(DispatcherType.class)).disable(Disables.webExtension().and(Disables.jerseyExtension().negate())).listen(event -> {
            if (event.getType().equals((Object)GuiceyLifecycle.ApplicationRun)) {
                ApplicationRunEvent evt = (ApplicationRunEvent)event;
                this.registerDropwizardExtensions(evt.getEnvironment(), this.config.isDisableDropwizardExceptionMappers());
                this.start(this.config, evt.getEnvironment());
            }
        }).onApplicationShutdown(injector -> this.stop());
        this.disableResources(this.config, builder);
        this.disableJerseyExtensions(this.config, builder);
    }

    public GuiceyJerseyTest getJerseyStub() {
        return this.jerseyStub;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    private void registerDropwizardExtensions(Environment environment, boolean disableExceptionMappers) {
        if (!disableExceptionMappers) {
            environment.jersey().register((Object)new ExceptionMapperBinder(false));
        }
        environment.jersey().register((Object)new JacksonFeature(environment.getObjectMapper()));
        environment.jersey().register((Object)new HibernateValidationBinder(environment.getValidator()));
    }

    private void start(StubRestConfig config, Environment environment) {
        this.jerseyStub = GuiceyJerseyTest.create(environment, config.getContainer(), config.isLogRequests());
        try {
            this.jerseyStub.setUp();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start test jersey container", e);
        }
        this.restClient = new RestClient(this.jerseyStub);
    }

    private void stop() {
        if (this.jerseyStub != null) {
            try {
                this.jerseyStub.tearDown();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to shutdown test jersey container", e);
            }
        }
    }

    private void disableResources(StubRestConfig config, GuiceBundle.Builder builder) {
        Predicate<ItemInfo> resourcesDisable = null;
        if (!config.getResources().isEmpty()) {
            resourcesDisable = Disables.installedBy(ResourceInstaller.class).and(Disables.type((Class[])config.getResources().toArray(Class[]::new)).negate());
        } else if (!config.getDisableResources().isEmpty()) {
            resourcesDisable = Disables.installedBy(ResourceInstaller.class).and(Disables.type((Class[])config.getDisableResources().toArray(Class[]::new)));
        }
        if (resourcesDisable != null) {
            builder.disable(resourcesDisable);
        }
    }

    private void disableJerseyExtensions(StubRestConfig config, GuiceBundle.Builder builder) {
        Predicate<ItemInfo> extDisable = null;
        if (!config.getJerseyExtensions().isEmpty()) {
            extDisable = Disables.jerseyExtension().and(Disables.installedBy(ResourceInstaller.class).negate()).and(Disables.type((Class[])config.getJerseyExtensions().toArray(Class[]::new)).negate());
        } else if (config.isDisableAllJerseyExtensions() || !config.getDisableJerseyExtensions().isEmpty()) {
            extDisable = Disables.jerseyExtension().and(Disables.installedBy(ResourceInstaller.class).negate());
            if (!config.isDisableAllJerseyExtensions()) {
                extDisable = extDisable.and(Disables.type((Class[])config.getDisableJerseyExtensions().toArray(Class[]::new)));
            }
        }
        if (extDisable != null) {
            builder.disable(extDisable);
        }
    }

    public static class Builder {
        private final StubRestConfig config = new StubRestConfig();

        public Builder resources(Class<?> ... resources) {
            Collections.addAll(this.config.getResources(), resources);
            return this;
        }

        public Builder disableResources(Class<?> ... disableResources) {
            Collections.addAll(this.config.getDisableResources(), disableResources);
            return this;
        }

        public Builder jerseyExtensions(Class<?> ... jerseyExtensions) {
            Collections.addAll(this.config.getJerseyExtensions(), jerseyExtensions);
            return this;
        }

        public Builder disableAllJerseyExtensions(boolean disableAllJerseyExtensions) {
            this.config.setDisableAllJerseyExtensions(disableAllJerseyExtensions);
            return this;
        }

        public Builder disableDropwizardExceptionMappers(boolean disableDropwizardExceptionMappers) {
            this.config.setDisableDropwizardExceptionMappers(disableDropwizardExceptionMappers);
            return this;
        }

        public Builder disableJerseyExtensions(Class<?> ... disableJerseyExtensions) {
            Collections.addAll(this.config.getDisableJerseyExtensions(), disableJerseyExtensions);
            return this;
        }

        public Builder logRequests(boolean logRequests) {
            this.config.setLogRequests(logRequests);
            return this;
        }

        public Builder container(TestContainerPolicy policy) {
            this.config.setContainer(policy);
            return this;
        }

        public RestStubsHook build() {
            return new RestStubsHook(this.config);
        }
    }
}

