/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.rest.support;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.Filters;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.ResourceInstaller;

public class ExtensionsSelector {
    private final GuiceyConfigurationInfo info;

    public ExtensionsSelector(GuiceyConfigurationInfo info) {
        this.info = info;
    }

    public List<Class<?>> getResources() {
        return this.info.getData().getItems(Filters.extensions().and(Filters.installedBy(ResourceInstaller.class)).and(Filters.enabled())).stream().map(ItemId::getType).sorted(Comparator.comparing(Class::getSimpleName)).collect(Collectors.toList());
    }

    public int getDisabledResourcesCount() {
        return this.info.getData().getItems(Filters.extensions().and(Filters.installedBy(ResourceInstaller.class)).and(Filters.disabled())).size();
    }

    public List<Class<?>> getExtensions() {
        return this.info.getData().getItems(Filters.extensions().and(Filters.jerseyExtension().and(Filters.installedBy(ResourceInstaller.class).negate())).and(Filters.enabled())).stream().map(ItemId::getType).sorted(Comparator.comparing(Class::getSimpleName)).collect(Collectors.toList());
    }

    public int getDisabledExtensionsCount() {
        return this.info.getData().getItems(Filters.extensions().and(Filters.jerseyExtension().and(Filters.installedBy(ResourceInstaller.class).negate())).and(Filters.disabled())).size();
    }
}

