/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.spy;

import com.google.common.base.Preconditions;
import com.google.inject.matcher.Matchers;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.mockito.Mockito;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.spy.SpyProxy;

public class SpiesHook
implements GuiceyConfigurationHook {
    private final Map<Class<?>, SpyProxy> spies = new HashMap();
    private boolean initialized;

    @Override
    public void configure(GuiceBundle.Builder builder) throws Exception {
        if (!this.spies.isEmpty()) {
            builder.modulesOverride(binder -> this.spies.forEach((type, spy) -> {
                spy.setInstanceProvider(binder.getProvider(type));
                binder.bindInterceptor(Matchers.only((Object)type), Matchers.any(), new MethodInterceptor[]{spy});
            }));
        }
        this.initialized = true;
    }

    public <T> SpyProxy<T> spy(Class<T> type) {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Too late. Spies already applied.");
        Preconditions.checkState((!this.spies.containsKey(type) ? 1 : 0) != 0, (String)"Mock object for type %s is already registered.", (Object)type.getSimpleName());
        SpyProxy<T> spy = new SpyProxy<T>(type);
        this.spies.put(type, spy);
        return spy;
    }

    public <T> T getSpy(Class<T> type) {
        return ((SpyProxy)Preconditions.checkNotNull((Object)this.spies.get(type), (String)"Spy not registered for type %s", (Object)type.getSimpleName())).getSpy();
    }

    public void resetSpies() {
        this.spies.values().forEach(spyProxy -> Mockito.reset((Object[])new Object[]{spyProxy.getSpy()}));
    }
}

