/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.spy;

import com.google.common.base.Preconditions;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.mockito.Mockito;

public class SpyProxy<T>
implements MethodInterceptor,
Provider<T> {
    private final Class<T> type;
    private final List<Consumer<T>> startupInitializers = new ArrayList<Consumer<T>>();
    private Provider<T> instanceProvider;
    private volatile T spy;

    public SpyProxy(Class<T> type) {
        this.type = type;
    }

    public final SpyProxy<T> withInitializer(Consumer<T> initializer) {
        this.startupInitializers.add(initializer);
        return this;
    }

    public void setInstanceProvider(Provider<T> instanceProvider) {
        Preconditions.checkState((this.instanceProvider == null ? 1 : 0) != 0, (Object)"Instance provider already set");
        this.instanceProvider = instanceProvider;
    }

    public Class<T> getType() {
        return this.type;
    }

    public synchronized T getSpy() {
        if (this.spy == null) {
            Object bean = Preconditions.checkNotNull((Object)this.instanceProvider.get());
            this.spy = Mockito.spy((Object)bean);
            for (Consumer<T> initializer : this.startupInitializers) {
                initializer.accept(this.spy);
            }
        }
        return this.spy;
    }

    public T get() {
        return this.getSpy();
    }

    public synchronized Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean isSpyCalled;
        boolean bl = isSpyCalled = methodInvocation.getThis() == this.spy;
        if (isSpyCalled) {
            return methodInvocation.proceed();
        }
        return methodInvocation.getMethod().invoke(this.getSpy(), methodInvocation.getArguments());
    }
}

