/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.track;

import com.codahale.metrics.Timer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.time.Duration;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;

@SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
public class MethodTrack
implements Comparable<MethodTrack> {
    private final Method method;
    private final Class<?> service;
    private final String instanceHash;
    private final long started;
    private final Duration duration;
    private final Object[] rawArguments;
    private final String[] arguments;
    private final Object rawResult;
    private final String result;
    private final Throwable throwable;
    private final boolean[] stringMarkers;
    private final Timer timer;

    public MethodTrack(Class<?> service, Method method, String instanceHash, long started, Duration duration, Object[] rawArguments, String[] arguments, Object rawResult, String result, Throwable throwable, boolean[] stringMarkers, Timer timer) {
        this.method = method;
        this.service = service;
        this.instanceHash = instanceHash;
        this.started = started;
        this.duration = duration;
        this.rawArguments = rawArguments;
        this.arguments = arguments;
        this.rawResult = rawResult;
        this.result = this.isVoidMethod() ? null : result;
        this.throwable = throwable;
        this.stringMarkers = stringMarkers;
        this.timer = timer;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getService() {
        return this.service;
    }

    public String getInstanceHash() {
        return this.instanceHash;
    }

    public long getStarted() {
        return this.started;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Object[] getRawArguments() {
        return this.rawArguments;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public boolean isVoidMethod() {
        return this.method.getReturnType().equals(Void.TYPE);
    }

    public Object getRawResult() {
        return this.rawResult;
    }

    public String getResult() {
        return this.result;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isSuccess() {
        return this.throwable == null;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public String[] getQuotedArguments() {
        String[] res = new String[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            Object arg = this.arguments[i];
            if (this.stringMarkers[i]) {
                arg = "\"" + (String)arg + "\"";
            }
            res[i] = arg;
        }
        return res;
    }

    public String getQuotedResult() {
        if (this.isVoidMethod()) {
            return null;
        }
        return this.stringMarkers[this.arguments.length] ? "\"" + this.result + "\"" : this.result;
    }

    public String toStringTrack() {
        StringBuilder res = new StringBuilder(this.method.getName()).append('(').append(String.join((CharSequence)", ", this.getQuotedArguments())).append(')');
        if (!this.isSuccess()) {
            res.append(" ERROR ").append(this.throwable.getClass().getSimpleName()).append(": ").append(this.throwable.getMessage());
        } else if (!this.isVoidMethod()) {
            res.append(" = ").append(this.getQuotedResult());
        }
        return res.toString();
    }

    public String toString() {
        return this.toStringTrack() + "\t (" + PrintUtils.ms(this.duration) + ")";
    }

    @Override
    public int compareTo(MethodTrack o) {
        return Long.compare(this.started, o.getStarted());
    }
}

