/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.track;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Stopwatch;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import ru.vyarus.dropwizard.guice.test.track.Tracker;
import ru.vyarus.dropwizard.guice.test.track.TrackerConfig;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;

public class TrackerProxy<T>
implements MethodInterceptor {
    private final Tracker<T> tracker;
    private final int maxToString;

    public TrackerProxy(Class<T> type, TrackerConfig config, MetricRegistry metrics) {
        this.maxToString = config.getMaxStringLength();
        this.tracker = new Tracker<T>(type, config, metrics);
    }

    public Tracker<T> getTracker() {
        return this.tracker;
    }

    public synchronized Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object object;
        long start = System.currentTimeMillis();
        Stopwatch timer = Stopwatch.createStarted();
        Object[] arguments = methodInvocation.getArguments();
        String[] args = PrintUtils.toStringArguments(arguments, this.maxToString);
        boolean[] stringMarkers = new boolean[args.length + 1];
        for (int i = 0; i < args.length; ++i) {
            stringMarkers[i] = arguments[i] instanceof String;
        }
        Object result = null;
        Throwable error = null;
        try {
            object = result = methodInvocation.proceed();
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                stringMarkers[stringMarkers.length - 1] = result instanceof String;
                this.tracker.add(methodInvocation.getMethod(), PrintUtils.identity(methodInvocation.getThis()), start, timer.elapsed(), arguments, args, result, error != null ? null : PrintUtils.toStringValue(result, this.maxToString), error, stringMarkers);
                throw throwable;
            }
        }
        stringMarkers[stringMarkers.length - 1] = result instanceof String;
        this.tracker.add(methodInvocation.getMethod(), PrintUtils.identity(methodInvocation.getThis()), start, timer.elapsed(), arguments, args, result, error != null ? null : PrintUtils.toStringValue(result, this.maxToString), error, stringMarkers);
        return object;
    }
}

