/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import com.google.common.base.Preconditions;
import io.dropwizard.testing.ConfigOverride;
import java.util.function.Supplier;
import ru.vyarus.dropwizard.guice.test.util.ConfigurablePrefix;

public class ConfigOverrideValue
extends ConfigOverride
implements ConfigurablePrefix {
    private static final String DOT = ".";
    private final String key;
    private final Supplier<String> value;
    private String prefix;
    private String originalValue;

    public ConfigOverrideValue(String key, Supplier<String> value) {
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"Property name required");
        this.value = (Supplier)Preconditions.checkNotNull(value, (Object)"Value supplier required");
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix.endsWith(DOT) ? prefix : prefix + DOT;
    }

    public void addToSystemProperties() {
        Preconditions.checkNotNull((Object)this.prefix, (Object)"Prefix is not defined");
        this.originalValue = System.setProperty(this.prefix + this.key, this.value.get());
    }

    public void removeFromSystemProperties() {
        if (this.originalValue != null) {
            System.setProperty(this.prefix + this.key, this.originalValue);
        } else {
            System.clearProperty(this.prefix + this.key);
        }
    }
}

