/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.context.container.GenericArrayTypeImpl;
import ru.vyarus.java.generics.resolver.context.container.ParameterizedTypeImpl;
import ru.vyarus.java.generics.resolver.context.container.WildcardTypeImpl;

public final class GenericInfoUtils {
    private static final LinkedHashMap<String, Type> EMPTY_MAP = new LinkedHashMap(0);
    private static final String GROOVY_OBJECT = "GroovyObject";

    private GenericInfoUtils() {
    }

    public static GenericsInfo create(Class<?> type, Class<?> ... ignoreClasses) {
        HashMap generics = new HashMap();
        GenericInfoUtils.analyzeType(generics, type, Arrays.asList(ignoreClasses));
        return new GenericsInfo(type, generics);
    }

    private static void analyzeType(Map<Class<?>, LinkedHashMap<String, Type>> types, Class<?> type, List<Class<?>> ignoreClasses) {
        Class<?> supertype = type;
        while (true) {
            for (Type iface : supertype.getGenericInterfaces()) {
                GenericInfoUtils.analyzeInterface(types, iface, supertype, ignoreClasses);
            }
            Class<?> next = supertype.getSuperclass();
            if (next == null || Object.class == next || ignoreClasses.contains(next)) break;
            types.put(next, GenericInfoUtils.analyzeParent(supertype, (Map<String, Type>)types.get(supertype)));
            supertype = next;
        }
    }

    private static void analyzeInterface(Map<Class<?>, LinkedHashMap<String, Type>> types, Type iface, Class<?> supertype, List<Class<?>> ignoreClasses) {
        Class interfaceType;
        Class clazz = interfaceType = iface instanceof ParameterizedType ? (Class)((ParameterizedType)iface).getRawType() : (Class)iface;
        if (!ignoreClasses.contains(interfaceType)) {
            if (iface instanceof ParameterizedType) {
                ParameterizedType parametrization = (ParameterizedType)iface;
                LinkedHashMap<String, Type> generics = GenericInfoUtils.resolveGenerics(parametrization, (Map<String, Type>)types.get(supertype));
                if (types.containsKey(interfaceType) && !generics.equals(types.get(interfaceType))) {
                    throw new IllegalStateException(String.format("Duplicate interface %s declaration in hierarchy: can't properly resolve generics.", interfaceType.getName()));
                }
                types.put(interfaceType, generics);
            } else if (!GROOVY_OBJECT.equals(interfaceType.getSimpleName())) {
                types.put(interfaceType, EMPTY_MAP);
            }
            GenericInfoUtils.analyzeType(types, interfaceType, ignoreClasses);
        }
    }

    private static LinkedHashMap<String, Type> analyzeParent(Class type, Map<String, Type> rootGenerics) {
        LinkedHashMap<String, Type> generics = null;
        Class parent = type.getSuperclass();
        if (!type.isInterface() && parent != null && parent != Object.class && type.getGenericSuperclass() instanceof ParameterizedType) {
            generics = GenericInfoUtils.resolveGenerics((ParameterizedType)type.getGenericSuperclass(), rootGenerics);
        }
        return generics == null ? EMPTY_MAP : generics;
    }

    private static LinkedHashMap<String, Type> resolveGenerics(ParameterizedType type, Map<String, Type> rootGenerics) {
        LinkedHashMap<String, Type> generics = new LinkedHashMap<String, Type>();
        Type[] genericTypes = type.getActualTypeArguments();
        Class interfaceType = (Class)type.getRawType();
        TypeVariable<Class<T>>[] genericNames = interfaceType.getTypeParameters();
        int cnt = genericNames.length;
        for (int i = 0; i < cnt; ++i) {
            Type resolvedGenericType = GenericInfoUtils.resolveActualType(genericTypes[i], rootGenerics);
            generics.put(genericNames[i].getName(), resolvedGenericType);
        }
        return generics;
    }

    private static Type resolveActualType(Type genericType, Map<String, Type> rootGenerics) {
        Type resolvedGenericType = null;
        if (genericType instanceof TypeVariable) {
            resolvedGenericType = rootGenerics.get(((TypeVariable)genericType).getName());
        } else if (genericType instanceof Class) {
            resolvedGenericType = genericType;
        } else if (genericType instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)genericType;
            resolvedGenericType = new ParameterizedTypeImpl(parametrizedType.getRawType(), GenericInfoUtils.resolve(parametrizedType.getActualTypeArguments(), rootGenerics), parametrizedType.getOwnerType());
        } else if (genericType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)genericType;
            resolvedGenericType = new GenericArrayTypeImpl(GenericInfoUtils.resolveActualType(arrayType.getGenericComponentType(), rootGenerics));
        } else if (genericType instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)genericType;
            resolvedGenericType = new WildcardTypeImpl(GenericInfoUtils.resolve(wildcard.getUpperBounds(), rootGenerics), GenericInfoUtils.resolve(wildcard.getLowerBounds(), rootGenerics));
        }
        return resolvedGenericType;
    }

    private static Type[] resolve(Type[] types, Map<String, Type> rootGenerics) {
        Type[] resolved = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolved[i] = GenericInfoUtils.resolveActualType(types[i], rootGenerics);
        }
        return resolved;
    }
}

