/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.util.NoGenericException;

public final class GenericsUtils {
    private GenericsUtils() {
    }

    public static Class<?> getReturnClass(Method method, Map<String, Type> generics) {
        Type returnType = method.getGenericReturnType();
        return GenericsUtils.resolveClass(returnType, generics);
    }

    public static List<Class<?>> getMethodParameters(Method method, Map<String, Type> generics) {
        ArrayList params = new ArrayList();
        for (Type type : method.getGenericParameterTypes()) {
            params.add(GenericsUtils.resolveClass(type, generics));
        }
        return params;
    }

    public static List<Class<?>> resolveGenericsOf(Type type, Map<String, Type> generics) throws NoGenericException {
        Type[] actualTypeArguments;
        ArrayList res = new ArrayList();
        Type analyzingType = type;
        if (type instanceof TypeVariable) {
            analyzingType = generics.get(((TypeVariable)type).getName());
        }
        if (!(analyzingType instanceof ParameterizedType) || ((ParameterizedType)analyzingType).getActualTypeArguments().length == 0) {
            throw new NoGenericException();
        }
        for (Type actual : actualTypeArguments = ((ParameterizedType)analyzingType).getActualTypeArguments()) {
            if (actual instanceof Class) {
                res.add((Class)actual);
                continue;
            }
            res.add(GenericsUtils.resolveClass(actual, generics));
        }
        return res;
    }

    public static Class<?> resolveClass(Type type, Map<String, Type> generics) {
        Class<?> res;
        if (type instanceof Class) {
            res = (Class<?>)type;
        } else if (type instanceof ParameterizedType) {
            res = GenericsUtils.resolveClass(((ParameterizedType)type).getRawType(), generics);
        } else if (type instanceof TypeVariable) {
            res = GenericsUtils.resolveClass(generics.get(((TypeVariable)type).getName()), generics);
        } else if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            res = GenericsUtils.resolveClass(upperBounds[0], generics);
        } else {
            Class<?> arrayType = GenericsUtils.resolveClass(((GenericArrayType)type).getGenericComponentType(), generics);
            try {
                res = arrayType.isArray() ? Class.forName("[" + arrayType.getName()) : Class.forName("[L" + arrayType.getName() + ";");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to create array class", e);
            }
        }
        return res;
    }
}

