/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.NoGenericException;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;

public class GenericsContext {
    private final GenericsInfo genericsInfo;
    private final Class<?> currentType;
    private final Map<String, Type> typeGenerics;

    public GenericsContext(GenericsInfo genericsInfo, Class<?> type) {
        this.genericsInfo = genericsInfo;
        this.currentType = type;
        this.typeGenerics = genericsInfo.getTypeGenerics(type);
    }

    public Class<?> currentClass() {
        return this.currentType;
    }

    public List<Type> genericTypes() {
        return new ArrayList<Type>(this.typeGenerics.values());
    }

    public List<Class<?>> generics() {
        ArrayList res = new ArrayList();
        for (Type type : this.typeGenerics.values()) {
            res.add(this.resolveClass(type));
        }
        return res;
    }

    public List<String> genericsAsString() {
        ArrayList<String> res = new ArrayList<String>();
        for (Type type : this.typeGenerics.values()) {
            res.add(this.toStringType(type));
        }
        return res;
    }

    public Type genericType(int position) {
        return this.genericTypes().get(position);
    }

    public Type genericType(String genericName) {
        return this.typeGenerics.get(this.checkGenericName(genericName));
    }

    public Class<?> generic(int position) {
        return this.resolveClass(this.genericTypes().get(position));
    }

    public Class<?> generic(String genericName) {
        return this.resolveClass(this.typeGenerics.get(this.checkGenericName(genericName)));
    }

    public String genericAsString(int position) {
        return this.toStringType(this.genericType(position));
    }

    public String genericAsString(String genericName) {
        return this.toStringType(this.typeGenerics.get(this.checkGenericName(genericName)));
    }

    public Map<String, Type> genericsMap() {
        return new LinkedHashMap<String, Type>(this.typeGenerics);
    }

    public GenericsInfo getGenericsInfo() {
        return this.genericsInfo;
    }

    public Class<?> resolveReturnClass(Method method) {
        return GenericsUtils.getReturnClass(method, this.typeGenerics);
    }

    public List<Class<?>> resolveParameters(Method method) {
        return GenericsUtils.getMethodParameters(method, this.typeGenerics);
    }

    public Class<?> resolveClass(Type type) {
        return GenericsUtils.resolveClass(type, this.typeGenerics);
    }

    public List<Class<?>> resolveGenericsOf(Type type) throws NoGenericException {
        return GenericsUtils.resolveGenericsOf(type, this.typeGenerics);
    }

    public Class<?> resolveGenericOf(Type type) throws NoGenericException {
        return this.resolveGenericsOf(type).get(0);
    }

    public String toStringType(Type type) {
        return TypeToStringUtils.toStringType(type, this.typeGenerics);
    }

    public GenericsContext type(Class<?> type) {
        return new GenericsContext(this.genericsInfo, type);
    }

    private String checkGenericName(String genericName) {
        if (!this.typeGenerics.containsKey(genericName)) {
            throw new IllegalArgumentException(String.format("Type %s doesn't contain generic with name '%s'", this.currentType.getName(), genericName));
        }
        return genericName;
    }
}

