/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.error;

import java.lang.reflect.GenericDeclaration;
import ru.vyarus.java.generics.resolver.error.GenericSourceException;

public class UnknownGenericException
extends GenericSourceException {
    private final String genericName;
    private final GenericDeclaration genericSource;
    private final Class<?> contextType;

    public UnknownGenericException(String genericName, GenericDeclaration genericSource) {
        this(null, genericName, genericSource);
    }

    public UnknownGenericException(Class<?> contextType, String genericName, GenericDeclaration genericSource) {
        this(contextType, genericName, genericSource, null);
    }

    private UnknownGenericException(Class<?> contextType, String genericName, GenericDeclaration genericSource, Throwable cause) {
        super(String.format("Generic '%s'%s is not declared %s", genericName, UnknownGenericException.formatSource(genericSource), contextType == null ? "" : "on type " + contextType.getName()), cause);
        this.contextType = contextType;
        this.genericName = genericName;
        this.genericSource = genericSource;
    }

    @Override
    public String getGenericName() {
        return this.genericName;
    }

    @Override
    public GenericDeclaration getGenericSource() {
        return this.genericSource;
    }

    @Override
    public Class<?> getContextType() {
        return this.contextType;
    }

    public UnknownGenericException rethrowWithType(Class<?> type) {
        boolean sameType;
        boolean bl = sameType = this.contextType != null && this.contextType.equals(type);
        if (!sameType && this.contextType != null) {
            throw new IllegalStateException("Context type can't be changed");
        }
        return sameType ? this : new UnknownGenericException(type, this.genericName, this.genericSource, this);
    }
}

