/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.GenericDeclarationScope;
import ru.vyarus.java.generics.resolver.context.GenericsContext;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.util.GenericsResolutionUtils;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;

public class MethodGenericsContext
extends GenericsContext {
    private final Method meth;
    private Map<String, Type> methodGenerics;
    private Map<String, Type> allGenerics;

    public MethodGenericsContext(GenericsInfo genericsInfo, Method method, GenericsContext root) {
        super(genericsInfo, method.getDeclaringClass(), root);
        this.meth = method;
        this.initGenerics();
    }

    public Method currentMethod() {
        return this.meth;
    }

    public List<Type> methodGenericTypes() {
        return this.methodGenerics.isEmpty() ? Collections.emptyList() : new ArrayList<Type>(this.methodGenerics.values());
    }

    public Map<String, Type> methodGenericsMap() {
        return this.methodGenerics.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, Type>(this.methodGenerics);
    }

    public Class<?> resolveReturnClass() {
        return GenericsUtils.getReturnClass(this.meth, this.contextGenerics());
    }

    public List<Class<?>> resolveParameters() {
        return GenericsUtils.resolveClasses(this.meth.getGenericParameterTypes(), this.contextGenerics());
    }

    public List<Type> resolveParametersTypes() {
        return Arrays.asList(GenericsUtils.resolveTypeVariables(this.meth.getGenericParameterTypes(), this.contextGenerics()));
    }

    public Type resolveParameterType(int pos) {
        this.checkParameter(pos);
        return this.resolveType(this.meth.getGenericParameterTypes()[pos]);
    }

    public GenericsContext parameterType(int pos) {
        this.checkParameter(pos);
        return this.inlyingType(this.meth.getGenericParameterTypes()[pos]);
    }

    public GenericsContext parameterTypeAs(int pos, Class<?> asType) {
        this.checkParameter(pos);
        return this.inlyingTypeAs(this.meth.getGenericParameterTypes()[pos], asType);
    }

    public List<Class<?>> resolveReturnTypeGenerics() {
        return GenericsUtils.resolveGenericsOf(this.meth.getGenericReturnType(), this.contextGenerics());
    }

    public Class<?> resolveReturnTypeGeneric() {
        List<Class<?>> res = this.resolveReturnTypeGenerics();
        return res.isEmpty() ? null : res.get(0);
    }

    public Type resolveReturnType() {
        return this.resolveType(this.meth.getGenericReturnType());
    }

    public GenericsContext returnType() {
        return this.inlyingType(this.meth.getGenericReturnType());
    }

    public GenericsContext returnTypeAs(Class<?> asType) {
        return this.inlyingTypeAs(this.meth.getGenericReturnType(), asType);
    }

    public String toStringMethod() {
        return TypeToStringUtils.toStringMethod(this.meth, this.contextGenerics());
    }

    @Override
    public String toString() {
        return this.genericsInfo.toStringHierarchy(new MethodContextWriter());
    }

    @Override
    public GenericDeclarationScope getGenericsScope() {
        return GenericDeclarationScope.METHOD;
    }

    @Override
    public GenericDeclaration getGenericsSource() {
        return this.currentMethod();
    }

    @Override
    public MethodGenericsContext method(Method method) {
        return method == this.currentMethod() ? this : super.method(method);
    }

    @Override
    protected Map<String, Type> contextGenerics() {
        return this.allGenerics;
    }

    private void initGenerics() {
        TypeVariable<Method>[] methodGenerics = this.meth.getTypeParameters();
        boolean hasMethodGenerics = methodGenerics.length > 0;
        Map<Object, Object> map = this.methodGenerics = hasMethodGenerics ? GenericsResolutionUtils.resolveDirectRawGenerics(this.meth, (Map<String, Type>)this.allTypeGenerics) : Collections.emptyMap();
        if (hasMethodGenerics) {
            this.allGenerics = new LinkedHashMap<String, Type>(this.allTypeGenerics);
            this.allGenerics.putAll(this.methodGenerics);
        } else {
            this.allGenerics = this.allTypeGenerics;
        }
    }

    private void checkParameter(int pos) {
        Type[] genericParams = this.meth.getGenericParameterTypes();
        if (pos < 0 || pos >= genericParams.length) {
            throw new IllegalArgumentException(String.format("Can't request parameter %s of method '%s' (%s) because it have only %s parameters", pos, this.toStringMethod(), this.currentClass().getSimpleName(), genericParams.length));
        }
    }

    class MethodContextWriter
    extends GenericsContext.RootContextAwareTypeWriter {
        MethodContextWriter() {
        }

        @Override
        public String write(Class<?> type, Map<String, Type> generics, Class<?> owner, Map<String, Type> ownerGenerics, String shift) {
            String method = "";
            if (type == MethodGenericsContext.this.currentType) {
                method = String.format("%n%s%s%s%s", shift, "  ", MethodGenericsContext.this.toStringMethod(), "    <-- current");
            }
            return super.write(type, generics, owner, ownerGenerics, shift) + method;
        }
    }
}

