/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.error;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import ru.vyarus.java.generics.resolver.context.GenericDeclarationScope;
import ru.vyarus.java.generics.resolver.error.GenericsException;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.map.PrintableGenericsMap;

public abstract class GenericSourceException
extends GenericsException {
    public GenericSourceException(String message) {
        super(message);
    }

    public GenericSourceException(String message, Throwable cause) {
        super(message, cause);
    }

    public abstract String getGenericName();

    public abstract GenericDeclaration getGenericSource();

    public abstract Class<?> getContextType();

    protected static String formatSource(GenericDeclaration source) {
        String res;
        GenericDeclarationScope scope = GenericDeclarationScope.from(source);
        if (scope != null) {
            StringBuilder place = new StringBuilder();
            switch (scope) {
                case METHOD: {
                    Method method = (Method)source;
                    place.append(method.getDeclaringClass().getSimpleName()).append('#').append(GenericSourceException.formatGenerics(method.getTypeParameters())).append(TypeToStringUtils.toStringMethod(method, new PrintableGenericsMap()));
                    break;
                }
                case CONSTRUCTOR: {
                    Constructor ctor = (Constructor)source;
                    place.append(GenericSourceException.formatGenerics(ctor.getTypeParameters())).append(TypeToStringUtils.toStringConstructor(ctor, new PrintableGenericsMap()));
                    break;
                }
                default: {
                    place.append(TypeToStringUtils.toStringWithNamedGenerics((Class)source));
                }
            }
            res = place.length() == 0 ? "" : " (defined on " + place + ")";
        } else {
            res = "";
        }
        return res;
    }

    private static String formatGenerics(TypeVariable ... generics) {
        StringBuilder res = new StringBuilder(generics.length * 5);
        res.append('<');
        boolean first = true;
        for (TypeVariable variable : generics) {
            res.append(!first ? ", " : "").append(variable.getName());
            first = false;
        }
        res.append("> ");
        return res.toString();
    }
}

