/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.mkdocs.task;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import ru.vyarus.gradle.plugin.mkdocs.MkdocsExtension;
import ru.vyarus.gradle.plugin.mkdocs.task.MkdocsTask;
import ru.vyarus.gradle.plugin.mkdocs.util.MkdocsConfig;
import ru.vyarus.gradle.plugin.mkdocs.util.TemplateUtils;
import ru.vyarus.gradle.plugin.mkdocs.util.VersionsFileUtils;

public abstract class MkdocsBuildTask
extends MkdocsTask {
    private static final String SITE_URL = "site_url";
    @Internal
    private Provider<Directory> projectBuildDir;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MkdocsBuildTask() {
        DirectoryProperty directoryProperty;
        this.projectBuildDir = directoryProperty = this.getProject().getLayout().getBuildDirectory();
        this.getCommand().set(this.getProject().provider((Callable)((Object)new _closure1((Object)this, (Object)this))));
    }

    @OutputDirectory
    public abstract Property<File> getOutputDir();

    @Input
    public abstract Property<Boolean> getUpdateSiteUrl();

    @Input
    public abstract Property<String> getVersionPath();

    @Input
    @Optional
    public abstract Property<String> getVersionName();

    @Input
    @Optional
    public abstract Property<String> getRootRedirectPath();

    @Input
    @Optional
    public abstract ListProperty<String> getVersionAliases();

    @OutputDirectory
    public abstract Property<File> getBuildDir();

    @Input
    @Optional
    public abstract Property<String> getExistingVersionFile();

    @Override
    public void run() {
        String path = ShortTypeHandling.castToString((Object)this.getVersionPath().get());
        boolean multiVersion = ScriptBytecodeAdapter.compareNotEqual((Object)path, (Object)MkdocsExtension.getSINGLE_VERSION_PATH());
        public final class _run_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _run_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                ((MkdocsBuildTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), MkdocsBuildTask.class))).super$6$run();
                return null;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        _run_closure2 action = new _run_closure2((Object)this, (Object)this);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.getUpdateSiteUrl().get()) && multiVersion) {
            this.withModifiedConfig(path, action);
        } else {
            action.call();
        }
        this.dockerChown(((File)this.getOutputDir().get()).toPath());
        this.updateVersions();
        if (multiVersion) {
            this.copyRedirect(path);
            this.copyAliases(path);
        }
    }

    @InputDirectory
    public File getSourcesDirectory() {
        return this.getFs().file(this.getSourcesDir().get());
    }

    private void withModifiedConfig(String path, Closure action) {
        MkdocsConfig conf = new MkdocsConfig(this.getFs(), ShortTypeHandling.castToString((Object)this.getSourcesDir().get()));
        String url = conf.find(SITE_URL);
        if (!DefaultTypeTransformation.booleanUnbox((Object)url) || url.endsWith(path) || url.endsWith(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"", "/"})))) {
            action.call();
            return;
        }
        File backup = conf.backup();
        try {
            String slash = "/";
            String folderUrl = StringGroovyMethods.plus((String)(url.endsWith(slash) ? url : StringGroovyMethods.plus((String)url, (CharSequence)slash)), (CharSequence)path);
            conf.set(SITE_URL, folderUrl);
            this.getLogger().lifecycle(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getFs().relativePath((Object)conf.getConfig()), SITE_URL, folderUrl}, new String[]{"Modified ", ": '", ": ", "'"})));
            action.call();
            conf.restoreBackup(backup);
        }
        catch (Throwable throwable) {
            conf.restoreBackup(backup);
            this.getLogger().lifecycle(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getFs().relativePath((Object)conf.getConfig())}, new String[]{"Original ", " restored"})));
            throw throwable;
        }
        this.getLogger().lifecycle(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getFs().relativePath((Object)conf.getConfig())}, new String[]{"Original ", " restored"})));
    }

    private void updateVersions() {
        String versions = ShortTypeHandling.castToString((Object)this.getExistingVersionFile().getOrNull());
        if (DefaultTypeTransformation.booleanUnbox((Object)versions)) {
            File target = null;
            if (versions.contains(":")) {
                target = new File(((Directory)this.projectBuildDir.get()).getAsFile(), "old-versions.json");
                this.download(versions, target);
            } else {
                target = this.getFs().file((Object)versions);
            }
            File res = VersionsFileUtils.getTarget((File)ScriptBytecodeAdapter.castToType((Object)this.getBuildDir().get(), File.class));
            this.getLogger().lifecycle("Creating versions file: {}", new Object[]{this.getFs().relativePath((Object)res)});
            Map<String, Map<String, Object>> parse = VersionsFileUtils.parse(target);
            if (target.exists()) {
                this.getLogger().lifecycle("\tExisting versions file '{}' loaded with {} versions", new Object[]{versions, parse.size()});
            } else {
                this.getLogger().warn("\tWARNING: configured versions file '{}' does not exist - creating new file instead", (Object)versions);
            }
            String currentVersion = ShortTypeHandling.castToString((Object)this.getVersionPath().get());
            if (VersionsFileUtils.addVersion(parse, currentVersion)) {
                this.getLogger().lifecycle("\tNew version added: {}", new Object[]{currentVersion});
            }
            VersionsFileUtils.updateVersion(parse, currentVersion, ShortTypeHandling.castToString((Object)this.getVersionName().get()), (List)ScriptBytecodeAdapter.castToType((Object)this.getVersionAliases().get(), List.class));
            VersionsFileUtils.write(parse, res);
            this.getLogger().lifecycle("\tVersions written to file: {}", new Object[]{DefaultGroovyMethods.join(parse.keySet(), (String)", ")});
        }
    }

    private void download(String src, File target) {
        CallSite[] callSiteArray = MkdocsBuildTask.$getCallSiteArray();
        callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"src", src, "dest", target, "maxtime", 5, "skipexisting", true, "ignoreerrors", true}));
    }

    private void copyRedirect(String path) {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.getRootRedirectPath().getOrNull())) {
            String target = ShortTypeHandling.castToString((Object)this.getRootRedirectPath().get());
            ArrayList possible = (ArrayList)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{path}), ArrayList.class);
            possible.addAll((Collection)ScriptBytecodeAdapter.castToType((Object)this.getVersionAliases().get(), Collection.class));
            if (!possible.contains(target)) {
                throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{target}, new String[]{"Invalid mkdocs.publish.rootRedirectTo option value: '", "'. "}).plus((GString)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Iterable)possible, (String)", ")}, new String[]{"Possible values are: ", " ('$docPath' for actual version)"}))));
            }
            TemplateUtils.copy(this.getFs(), "/ru/vyarus/gradle/plugin/mkdocs/template/publish/", this.getFs().relativePath(this.getBuildDir().get()), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"docPath", target}));
            this.getLogger().lifecycle("Root redirection enabled to: {}", new Object[]{target});
        } else {
            File index = new File((File)ScriptBytecodeAdapter.castToType((Object)this.getBuildDir().get(), File.class), "index.html");
            if (index.exists()) {
                index.delete();
            }
        }
    }

    private void copyAliases(String version) {
        Reference version2 = new Reference((Object)version);
        CallSite[] callSiteArray = MkdocsBuildTask.$getCallSiteArray();
        Reference baseDir = new Reference((Object)((File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), File.class)));
        List aliases = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)aliases)) {
            public final class _copyAliases_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference baseDir;
                private /* synthetic */ Reference version;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _copyAliases_closure3(Object _outerInstance, Object _thisObject, Reference baseDir, Reference version) {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _copyAliases_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.baseDir = reference2 = baseDir;
                    this.version = reference = version;
                }

                public Object doCall(String alias) {
                    Reference alias2 = new Reference((Object)alias);
                    CallSite[] callSiteArray = _copyAliases_closure3.$getCallSiteArray();
                    public final class _closure4
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference baseDir;
                        private /* synthetic */ Reference version;
                        private /* synthetic */ Reference alias;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure4(Object _outerInstance, Object _thisObject, Reference baseDir, Reference version, Reference alias) {
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.baseDir = reference3 = baseDir;
                            this.version = reference2 = version;
                            this.alias = reference = alias;
                        }

                        public Object doCall(Object spec) {
                            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                            callSiteArray[0].call(spec, callSiteArray[1].callConstructor(File.class, this.baseDir.get(), this.version.get()));
                            return callSiteArray[2].call(spec, callSiteArray[3].callConstructor(File.class, this.baseDir.get(), this.alias.get()));
                        }

                        @Generated
                        public File getBaseDir() {
                            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                            return (File)ScriptBytecodeAdapter.castToType((Object)this.baseDir.get(), File.class);
                        }

                        @Generated
                        public String getVersion() {
                            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                            return ShortTypeHandling.castToString((Object)this.version.get());
                        }

                        @Generated
                        public String getAlias() {
                            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                            return ShortTypeHandling.castToString((Object)this.alias.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure4.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "from";
                            stringArray[1] = "<$constructor$>";
                            stringArray[2] = "into";
                            stringArray[3] = "<$constructor$>";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[4];
                            _closure4.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure4.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure4.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)new _closure4((Object)this, this.getThisObject(), this.baseDir, this.version, alias2));
                }

                @Generated
                public Object call(String alias) {
                    Reference alias2 = new Reference((Object)alias);
                    CallSite[] callSiteArray = _copyAliases_closure3.$getCallSiteArray();
                    if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return callSiteArray[2].callCurrent((GroovyObject)this, (Object)((String)alias2.get()));
                    }
                    return this.doCall((String)alias2.get());
                }

                @Generated
                public File getBaseDir() {
                    CallSite[] callSiteArray = _copyAliases_closure3.$getCallSiteArray();
                    return (File)ScriptBytecodeAdapter.castToType((Object)this.baseDir.get(), File.class);
                }

                @Generated
                public String getVersion() {
                    CallSite[] callSiteArray = _copyAliases_closure3.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.version.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _copyAliases_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "copy";
                    stringArray[1] = "fs";
                    stringArray[2] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _copyAliases_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_copyAliases_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _copyAliases_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[6].call((Object)aliases, (Object)new _copyAliases_closure3((Object)this, (Object)this, baseDir, version2));
            callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), (Object)"Version aliases added: {}", callSiteArray[9].call((Object)aliases, (Object)", "));
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != MkdocsBuildTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public Provider<Directory> getProjectBuildDir() {
        return this.projectBuildDir;
    }

    @Generated
    public void setProjectBuildDir(Provider<Directory> provider) {
        this.projectBuildDir = provider;
    }

    public /* synthetic */ MetaClass super$6$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$6$run() {
        super.run();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "ant";
        stringArray[2] = "get";
        stringArray[3] = "buildDir";
        stringArray[4] = "get";
        stringArray[5] = "versionAliases";
        stringArray[6] = "each";
        stringArray[7] = "lifecycle";
        stringArray[8] = "logger";
        stringArray[9] = "join";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[10];
        MkdocsBuildTask.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MkdocsBuildTask.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MkdocsBuildTask.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public List<String> doCall(Object it) {
            boolean isWindows = Os.isFamily((String)Os.FAMILY_WINDOWS);
            String path = ((File)((MkdocsBuildTask)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), MkdocsBuildTask.class))).getOutputDir().get()).getCanonicalPath();
            if (isWindows) {
                path = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"\"", "\""}));
            }
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{"build", "-c", "-d", path});
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public List<String> doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

