/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.quality.spotbugs;

import com.github.spotbugs.snom.SpotBugsBasePlugin;
import com.github.spotbugs.snom.SpotBugsExtension;
import com.github.spotbugs.snom.internal.SpotBugsTaskFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import ru.vyarus.gradle.plugin.quality.QualityExtension;

public class CustomSpotBugsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (project.getPlugins().hasPlugin(SpotBugsBasePlugin.class)) {
            return;
        }
        project.getPlugins().apply(SpotBugsBasePlugin.class);
        QualityExtension quality = (QualityExtension)project.getExtensions().findByType(QualityExtension.class);
        List requiredTasks = quality.getSourceSets().stream().map(it -> it.getTaskName("spotbugs", null)).collect(Collectors.toList());
        project.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{requiredTasks}));
        SpotBugsExtension extension = (SpotBugsExtension)project.getExtensions().findByType(SpotBugsExtension.class);
        new SpotBugsTaskFactory().generate(project, task -> task.init(extension));
    }
}

