/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.service.stat;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import ru.vyarus.gradle.plugin.python.service.stat.PythonStat;
import ru.vyarus.gradle.plugin.python.util.DurationFormatter;

public class StatsPrinter
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public StatsPrinter() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String print(List<PythonStat> stats) {
        if (stats.isEmpty()) {
            return "";
        }
        TreeSet<PythonStat> sorted = new TreeSet<PythonStat>(stats);
        Reference res = new Reference((Object)new StringBuilder("\nPython execution stats:\n\n"));
        public final class _print_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _print_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object it) {
                return ((PythonStat)it).getContainerName() != null;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _print_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        boolean dockerUsed = stats.stream().anyMatch((Predicate)ScriptBytecodeAdapter.castToType((Object)((Object)new _print_closure1(StatsPrinter.class, StatsPrinter.class)), Predicate.class));
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss:SSS");
        StatCollector collector = new StatCollector(sorted);
        String format = dockerUsed ? "%-37s    %-3s%-12s   %-20s %-10s %-8s %s%n" : "%-37s    %-3s%-12s   %s %-10s %-8s %s%n";
        ((StringBuilder)res.get()).append(String.format(format, "task", "", "started", dockerUsed ? "docker container" : "", "duration", "", ""));
        TreeSet<PythonStat> treeSet = sorted;
        PythonStat stat = null;
        Iterator<PythonStat> iterator = treeSet != null ? treeSet.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                stat = (PythonStat)ScriptBytecodeAdapter.castToType((Object)iterator.next(), PythonStat.class);
                DefaultGroovyMethods.collect((Object)collector);
                Object[] objectArray = new Object[7];
                objectArray[0] = stat.getFullTaskName();
                objectArray[1] = stat.getParallel() ? "||" : "";
                objectArray[2] = timeFormat.format(stat.getStart());
                String string = stat.getContainerName();
                objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
                objectArray[4] = DurationFormatter.format(stat.getDuration());
                objectArray[5] = stat.getSuccess() ? "" : "FAILED";
                objectArray[6] = stat.getCmd();
                ((StringBuilder)res.get()).append(String.format(format, objectArray));
            }
        }
        ((StringBuilder)res.get()).append("\n    Executed ").append(stats.size()).append(" commands in ").append(DurationFormatter.format(collector.getOverall())).append(" (overall)\n");
        if (!collector.getDuplicates().isEmpty()) {
            ((StringBuilder)res.get()).append("\n    Duplicate executions:\n");
            public final class _print_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference res;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _print_closure2(Object _outerInstance, Object _thisObject, Reference res) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.res = reference = res;
                }

                public List<PythonStat> doCall(Object it) {
                    ((StringBuilder)this.res.get()).append((CharSequence)new GStringImpl(new Object[]{((Map.Entry)it).getKey(), ((List)((Map.Entry)it).getValue()).size()}, new String[]{"\n\t\t", " (", ")\n"}));
                    public final class _closure3
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference res;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure3(Object _outerInstance, Object _thisObject, Reference res) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.res = reference = res;
                        }

                        public StringBuilder doCall(Object it) {
                            return ((StringBuilder)this.res.get()).append((CharSequence)new GStringImpl(new Object[]{((PythonStat)it).getFullTaskName(), ((PythonStat)it).getWorkDir()}, new String[]{"\t\t\t", "   (work dir: ", ")\n"}));
                        }

                        @Generated
                        public StringBuilder getRes() {
                            return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.res.get(), StringBuilder.class);
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public StringBuilder doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure3.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    return DefaultGroovyMethods.each((List)((List)ScriptBytecodeAdapter.castToType(((Map.Entry)it).getValue(), List.class)), (Closure)new _closure3((Object)this, this.getThisObject(), this.res));
                }

                @Generated
                public StringBuilder getRes() {
                    return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.res.get(), StringBuilder.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public List<PythonStat> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _print_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(collector.getDuplicates(), (Closure)new _print_closure2(StatsPrinter.class, StatsPrinter.class, res));
        }
        return ((StringBuilder)res.get()).toString();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(StatsPrinter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(StatsPrinter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(StatsPrinter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, StatsPrinter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(StatsPrinter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StatsPrinter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static class StatCollector
    implements GroovyObject {
        private long overall;
        private Map<String, List<PythonStat>> duplicates;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public StatCollector(Set<PythonStat> stats) {
            MetaClass metaClass;
            Map map;
            int n = 0;
            this.overall = n;
            this.duplicates = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Set<PythonStat> set = stats;
            PythonStat stat = null;
            Iterator<PythonStat> iterator = set != null ? set.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    stat = (PythonStat)ScriptBytecodeAdapter.castToType((Object)iterator.next(), PythonStat.class);
                    PythonStat stat2 = null;
                    Set<PythonStat> set2 = stats;
                    Iterator<PythonStat> iterator2 = set2 != null ? set2.iterator() : null;
                    if (iterator2 != null) {
                        while (iterator2.hasNext()) {
                            stat2 = (PythonStat)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), PythonStat.class);
                            if (!(ScriptBytecodeAdapter.compareNotEqual((Object)stat, (Object)stat2) && stat.inParallel(stat2))) continue;
                            boolean bl = true;
                            stat.setParallel(bl);
                            boolean bl2 = true;
                            stat2.setParallel(bl2);
                        }
                    }
                    List dups = (List)ScriptBytecodeAdapter.castToType(this.duplicates.get(stat.getCmd()), List.class);
                    if (dups == null) {
                        dups = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                        this.duplicates.put(stat.getCmd(), dups);
                    }
                    dups.add(stat);
                    long cfr_ignored_0 = this.overall + stat.getDuration();
                    this.overall = this.overall;
                }
            }
            DefaultGroovyMethods.removeAll(this.duplicates, (Closure)new _closure1(this, this));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(StatCollector.class, StatsPrinter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(StatCollector.class, StatsPrinter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(StatCollector.class, StatsPrinter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(StatCollector.class, StatsPrinter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(StatCollector.class, StatsPrinter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(StatCollector.class, StatsPrinter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, StatsPrinter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, StatsPrinter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(StatCollector.class, StatsPrinter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(StatCollector.class, StatsPrinter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != StatCollector.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public long getOverall() {
            return this.overall;
        }

        @Generated
        public void setOverall(long l) {
            this.overall = l;
        }

        @Generated
        public Map<String, List<PythonStat>> getDuplicates() {
            return this.duplicates;
        }

        @Generated
        public void setDuplicates(Map<String, List<PythonStat>> map) {
            this.duplicates = map;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object it) {
                return ((List)((Map.Entry)it).getValue()).size() == 1;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
    }
}

