/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.task;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import ru.vyarus.gradle.plugin.python.cmd.Python;
import ru.vyarus.gradle.plugin.python.cmd.docker.ContainerManager;
import ru.vyarus.gradle.plugin.python.cmd.docker.DockerConfig;
import ru.vyarus.gradle.plugin.python.cmd.docker.DockerFactory;
import ru.vyarus.gradle.plugin.python.cmd.env.Environment;
import ru.vyarus.gradle.plugin.python.service.EnvService;
import ru.vyarus.gradle.plugin.python.util.CliUtils;
import ru.vyarus.gradle.plugin.python.util.OutputLogger;

public abstract class BasePythonTask
extends DefaultTask
implements GroovyObject {
    @Nested
    private DockerEnv docker;
    private Python pythonCache;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    protected BasePythonTask() {
        MetaClass metaClass;
        Object object = this.getProject().getObjects().newInstance(DockerEnv.class, new Object[0]);
        this.docker = (DockerEnv)ScriptBytecodeAdapter.castToType((Object)object, DockerEnv.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string = "python";
        this.setGroup(string);
    }

    @Input
    @Optional
    public abstract Property<String> getPythonPath();

    @Input
    public abstract Property<Boolean> getUseCustomPython();

    @Input
    @Optional
    public abstract Property<String> getPythonBinary();

    @Input
    public abstract Property<Boolean> getValidateSystemBinary();

    @Input
    @Optional
    public abstract ListProperty<String> getPythonArgs();

    @Input
    @Optional
    public abstract MapProperty<String, Object> getEnvironment();

    @Input
    @Optional
    public abstract Property<String> getWorkDir();

    @Input
    @Optional
    public abstract Property<LogLevel> getLogLevel();

    @org.gradle.api.tasks.Internal
    public abstract Property<EnvService> getEnvService();

    @org.gradle.api.tasks.Internal
    public abstract Property<Environment> getGradleEnv();

    public void pythonArgs(String ... args) {
        if (DefaultTypeTransformation.booleanUnbox((Object)args)) {
            this.getPythonArgs().addAll((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class));
        }
    }

    public void environment(String name, Object value) {
        this.environment(ScriptBytecodeAdapter.createMap((Object[])new Object[]{name, value}));
    }

    public void environment(Map<String, Object> vars) {
        if (DefaultTypeTransformation.booleanUnbox(vars)) {
            this.getEnvironment().putAll(vars);
        }
    }

    public DockerEnv docker(Action<? super DockerEnv> action) {
        action.execute((Object)this.docker);
        return this.docker;
    }

    @org.gradle.api.tasks.Internal
    public boolean isWindows() {
        return this.getPython().isWindows();
    }

    @org.gradle.api.tasks.Internal
    public boolean isDockerUsed() {
        return DefaultTypeTransformation.booleanUnbox((Object)this.docker.getUse().get());
    }

    public void dockerChown(String dir) {
        this.dockerChown(((Environment)this.getGradleEnv().get()).file(dir).toPath());
    }

    public int dockerExec(Object cmd) {
        Reference cmd2 = new Reference(cmd);
        if (!this.isDockerUsed()) {
            return -1;
        }
        public final class _dockerExec_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference cmd;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _dockerExec_closure1(Object _outerInstance, Object _thisObject, Reference cmd) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.cmd = reference = cmd;
            }

            public Integer doCall(Object it) {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((Object)((BasePythonTask)((Object)this.getThisObject()))), (String)"dockerExec", (Object)new Object[]{this.cmd.get(), it}), Integer.class);
            }

            @Generated
            public Object getCmd() {
                return this.cmd.get();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Integer doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _dockerExec_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.intUnbox((Object)IOGroovyMethods.withStream((OutputStream)((Object)new OutputLogger(this.getLogger(), LogLevel.LIFECYCLE, "\t")), (Closure)new _dockerExec_closure1((Object)this, (Object)this, cmd2)));
    }

    @org.gradle.api.tasks.Internal
    protected Python getPython() {
        Object object = this.getUseCustomPython().get();
        String path = (object == null ? false : (Boolean)object) ? ShortTypeHandling.castToString((Object)this.getPythonPath().getOrNull()) : ((EnvService)this.getEnvService().get()).getPythonPath(((Environment)this.getGradleEnv().get()).getProjectPath());
        return this.buildPython(path, ShortTypeHandling.castToString((Object)this.getPythonBinary().getOrNull()));
    }

    protected void dockerChown(Path dir) {
        if (!this.isDockerUsed() || this.isWindows() || !CliUtils.isLinuxHost() || !Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Path projectDir = ((Environment)this.getGradleEnv().get()).getRootDir().toPath();
        int uid = DefaultTypeTransformation.intUnbox((Object)Files.getAttribute(projectDir, "unix:uid", LinkOption.NOFOLLOW_LINKS));
        int gid = DefaultTypeTransformation.intUnbox((Object)Files.getAttribute(projectDir, "unix:gid", LinkOption.NOFOLLOW_LINKS));
        this.dockerExec(ScriptBytecodeAdapter.createList((Object[])new Object[]{"chown", "-Rh", new GStringImpl(new Object[]{uid, gid}, new String[]{"", ":", ""}), dir.toAbsolutePath()}));
    }

    protected int dockerExec(Object cmd, OutputStream out) {
        if (!this.isDockerUsed()) {
            throw (Throwable)new GradleException("Docker command can't be executed: docker not enabled");
        }
        String[] args = CliUtils.parseArgs(cmd);
        ContainerManager manager = DockerFactory.getContainer(this.getDocker().toConfig(), (Environment)ScriptBytecodeAdapter.castToType((Object)this.getGradleEnv().get(), Environment.class));
        manager.restartIfRequired(this.getDocker().toConfig(), ShortTypeHandling.castToString((Object)this.getWorkDir().getOrNull()), (Map)ScriptBytecodeAdapter.castToType((Object)this.getEnvironment().get(), Map.class));
        manager.convertCommand(args);
        this.getLogger().lifecycle("[docker] {}", new Object[]{DefaultGroovyMethods.join((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (String)" ")});
        return manager.exec(args, out);
    }

    private Python buildPython(String pythonPath, String pythonBinary) {
        if (this.pythonCache == null) {
            Python python;
            this.pythonCache = python = new Python((Environment)ScriptBytecodeAdapter.castToType((Object)this.getGradleEnv().get(), Environment.class), pythonPath, pythonBinary).logLevel((LogLevel)ShortTypeHandling.castToEnum((Object)this.getLogLevel().get(), LogLevel.class)).workDir(ShortTypeHandling.castToString((Object)this.getWorkDir().getOrNull())).pythonArgs(this.getPythonArgs().get()).environment((Map)ScriptBytecodeAdapter.castToType((Object)this.getEnvironment().get(), Map.class)).validateSystemBinary(DefaultTypeTransformation.booleanUnbox((Object)this.getValidateSystemBinary().get())).withDocker(this.getDocker().toConfig()).validate();
        }
        return this.pythonCache;
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BasePythonTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BasePythonTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BasePythonTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BasePythonTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(BasePythonTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != BasePythonTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public DockerEnv getDocker() {
        return this.docker;
    }

    @Generated
    public void setDocker(DockerEnv dockerEnv) {
        this.docker = dockerEnv;
    }

    public static abstract class DockerEnv
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public DockerEnv() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Input
        public abstract Property<Boolean> getUse();

        @Input
        public abstract Property<String> getImage();

        @org.gradle.api.tasks.Internal
        public abstract Property<Boolean> getWindows();

        @Input
        public abstract Property<Boolean> getExclusive();

        @Input
        public abstract Property<Boolean> getUseHostNetwork();

        @Input
        public abstract SetProperty<String> getPorts();

        public void ports(Object ... ports) {
            public final class _ports_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _ports_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    ((DockerEnv)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DockerEnv.class)).getPorts().add((Object)String.valueOf(it));
                    return null;
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _ports_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((Object[])ports, (Closure)new _ports_closure1(this, this));
        }

        public DockerConfig toConfig() {
            DockerConfig dockerConfig;
            Object object = this.getUse().get();
            if (object == null ? false : (Boolean)object) {
                DockerConfig dockerConfig2 = new DockerConfig();
                Object object2 = this.getImage().get();
                dockerConfig2.setImage(ShortTypeHandling.castToString((Object)object2));
                Object object3 = this.getWindows().get();
                dockerConfig2.setWindows(DefaultTypeTransformation.booleanUnbox((Object)object3));
                Object object4 = this.getExclusive().get();
                dockerConfig2.setExclusive(DefaultTypeTransformation.booleanUnbox((Object)object4));
                boolean bl = DefaultTypeTransformation.booleanUnbox((Object)this.getUseHostNetwork().get()) && Os.isFamily((String)Os.FAMILY_UNIX) && !Os.isFamily((String)Os.FAMILY_MAC);
                dockerConfig2.setUseHostNetwork(bl);
                Set set = (Set)this.getPorts().get();
                dockerConfig2.setPorts(set);
                dockerConfig = dockerConfig2;
            } else {
                dockerConfig = null;
            }
            return (DockerConfig)ScriptBytecodeAdapter.castToType(dockerConfig, DockerConfig.class);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DockerEnv.class, BasePythonTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DockerEnv.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

