/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.task.pip.module;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import ru.vyarus.gradle.plugin.python.task.pip.PipModule;
import ru.vyarus.gradle.plugin.python.task.pip.module.FeaturePipModule;
import ru.vyarus.gradle.plugin.python.task.pip.module.VcsPipModule;

public class ModuleFactory
implements GroovyObject {
    private static final Pattern VCS_FORMAT;
    private static final String VERSION_SEPARATOR;
    private static final String VCS_VERSION_SEPARATOR;
    private static final Pattern FEATURE_FORMAT;
    private static final String QUALIFIER_START;
    private static final String QUALIFIER_END;
    private static final int DECL_PARTS = 2;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ModuleFactory() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static PipModule create(String descriptor) {
        PipModule res = null;
        res = descriptor.contains("#egg=") || descriptor.contains("/") ? ModuleFactory.parseVcsModule(descriptor) : (descriptor.contains(QUALIFIER_START) && descriptor.contains(QUALIFIER_END) ? ModuleFactory.parseFeatureModule(descriptor) : ModuleFactory.parseModule(descriptor));
        return res;
    }

    public static String findModuleDeclaration(String name, List<String> modules) {
        Reference nm = new Reference((Object)StringGroovyMethods.plus((String)name.toLowerCase(), (CharSequence)VERSION_SEPARATOR));
        Reference qualifNm = new Reference((Object)StringGroovyMethods.plus((String)name.toLowerCase(), (CharSequence)QUALIFIER_START));
        Reference vcsNm = new Reference((Object)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name.toLowerCase()}, new String[]{"#egg=", "-"})));
        public final class _findModuleDeclaration_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference qualifNm;
            private /* synthetic */ Reference nm;
            private /* synthetic */ Reference vcsNm;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findModuleDeclaration_closure1(Object _outerInstance, Object _thisObject, Reference qualifNm, Reference nm, Reference vcsNm) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.qualifNm = reference3 = qualifNm;
                this.nm = reference2 = nm;
                this.vcsNm = reference = vcsNm;
            }

            public Boolean doCall(Object it) {
                String mod = ((String)it).toLowerCase();
                if (mod.contains(ModuleFactory.pfaccess$0(null))) {
                    return mod.startsWith(ShortTypeHandling.castToString((Object)this.qualifNm.get()));
                }
                return mod.startsWith(ShortTypeHandling.castToString((Object)this.nm.get())) || mod.contains((CharSequence)ScriptBytecodeAdapter.castToType((Object)this.vcsNm.get(), CharSequence.class));
            }

            @Generated
            public String getQualifNm() {
                return ShortTypeHandling.castToString((Object)this.qualifNm.get());
            }

            @Generated
            public String getNm() {
                return ShortTypeHandling.castToString((Object)this.nm.get());
            }

            @Generated
            public String getVcsNm() {
                return ShortTypeHandling.castToString((Object)this.vcsNm.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findModuleDeclaration_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return ShortTypeHandling.castToString((Object)DefaultGroovyMethods.find(modules, (Closure)new _findModuleDeclaration_closure1(ModuleFactory.class, ModuleFactory.class, qualifNm, nm, vcsNm)));
    }

    private static PipModule parseVcsModule(String desc) {
        if (!desc.contains("@")) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ModuleFactory.wrongVcs(desc)}, new String[]{"", " '@version' part is required"})));
        }
        Matcher matcher = VCS_FORMAT.matcher(desc);
        if (!matcher.find()) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ModuleFactory.wrongVcs(desc)}, new String[]{"", " Module name not found"})));
        }
        String name = matcher.group(1).trim();
        if (!name.contains(VCS_VERSION_SEPARATOR)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ModuleFactory.wrongVcs(desc), name}, new String[]{"", " Module version is required in module (#egg=name-version): '", "'. "}).plus("This is important to be able to check up-to-date state without python run")));
        }
        String[] split = name.split(VCS_VERSION_SEPARATOR);
        String version = ((String)DefaultGroovyMethods.last((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)split, Object[].class)))).trim();
        String pkgName = StringGroovyMethods.getAt((String)name, (IntRange)new IntRange(true, 0, name.lastIndexOf(VCS_VERSION_SEPARATOR) - 1)).trim();
        String shortDesc = desc.replace(name, pkgName);
        return new VcsPipModule(shortDesc, pkgName, version);
    }

    private static PipModule parseFeatureModule(String desc) {
        Matcher matcher = FEATURE_FORMAT.matcher(desc);
        if (!matcher.matches()) {
            throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)"Incorrect pip module declaration (expected ", (CharSequence)new GStringImpl(new Object[]{desc}, new String[]{"'module[qualifier,qualifier2]:version'): '", "'"})));
        }
        String name = matcher.group(1).trim();
        String qualifier = matcher.group(2).trim();
        String version = matcher.group(3).trim();
        return DefaultTypeTransformation.booleanUnbox((Object)qualifier) ? new FeaturePipModule(name, qualifier, version) : new PipModule(name, version);
    }

    private static PipModule parseModule(String desc) {
        Object[] parts = desc.split(VERSION_SEPARATOR);
        if (parts.length != DECL_PARTS) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{desc}, new String[]{"Incorrect pip module declaration (must be 'module:version'): ", ""})));
        }
        String string = ((String)BytecodeInterface8.objectArrayGet((Object[])parts, (int)0)).trim();
        String string2 = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : null;
        String string3 = ((String)BytecodeInterface8.objectArrayGet((Object[])parts, (int)1)).trim();
        return new PipModule(ShortTypeHandling.castToString((Object)string2), ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : null)));
    }

    private static String wrongVcs(String desc) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{desc}, new String[]{"Incorrect pip vsc module declaration: '", "' (required format is "}).plus("'vcs+protocol://repo_url/@vcsVersion#egg=name-pkgVersion')."));
    }

    public static /* synthetic */ String pfaccess$0(ModuleFactory $that) {
        return ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.getField(ModuleFactory.class, ModuleFactory.class, (String)"QUALIFIER_START"));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ModuleFactory.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        String string;
        String string2;
        String string3;
        String string4;
        QUALIFIER_END = string4 = "]";
        QUALIFIER_START = string3 = "[";
        VCS_VERSION_SEPARATOR = string2 = "-";
        VERSION_SEPARATOR = string = ":";
        VCS_FORMAT = pattern2 = Pattern.compile("@[^#]+#egg=([^&]+)");
        FEATURE_FORMAT = pattern = Pattern.compile("(.+)\\[(.+)]\\s*:\\s*(.+)");
    }
}

