/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.gradle.plugin.python.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.math.BigDecimal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;

public class DurationFormatter
implements GroovyObject {
    private static final long MILLIS_PER_SECOND;
    private static final long MILLIS_PER_MINUTE;
    private static final long MILLIS_PER_HOUR;
    private static final long MILLIS_PER_DAY;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private DurationFormatter() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String format(long duration) {
        if (duration == 0L) {
            return "0ms";
        }
        StringBuilder result = new StringBuilder();
        long days = ((BigDecimal)NumberNumberDiv.div((Number)duration, (Number)MILLIS_PER_DAY)).longValue();
        duration = duration % MILLIS_PER_DAY;
        if (days > 0L) {
            DurationFormatter.append(result, days, "d");
        }
        long hours = ((BigDecimal)NumberNumberDiv.div((Number)duration, (Number)MILLIS_PER_HOUR)).longValue();
        duration = duration % MILLIS_PER_HOUR;
        if (hours > 0L) {
            DurationFormatter.append(result, hours, "h");
        }
        long minutes = ((BigDecimal)NumberNumberDiv.div((Number)duration, (Number)MILLIS_PER_MINUTE)).longValue();
        duration = duration % MILLIS_PER_MINUTE;
        if (minutes > 0L) {
            DurationFormatter.append(result, minutes, "m");
        }
        boolean secs = false;
        if (duration >= MILLIS_PER_SECOND) {
            int secondsScale = result.length() == 0 ? 2 : 0;
            DurationFormatter.append(result, BigDecimal.valueOf(duration).divide(BigDecimal.valueOf(MILLIS_PER_SECOND)).setScale(secondsScale, 4).stripTrailingZeros().toPlainString(), "s");
            secs = true;
            duration = duration % MILLIS_PER_SECOND;
        }
        if (!secs && duration > (long)0) {
            result.append(StringGroovyMethods.plus((Number)duration, (String)"ms"));
        }
        return result.toString();
    }

    private static void append(StringBuilder builder, Object num, String what) {
        if (builder.length() > 0) {
            builder.append(" ");
        }
        builder.append(num);
        builder.append(what);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DurationFormatter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        int n = 86400000;
        MILLIS_PER_DAY = n;
        int n2 = 3600000;
        MILLIS_PER_HOUR = n2;
        int n3 = 60000;
        MILLIS_PER_MINUTE = n3;
        int n4 = 1000;
        MILLIS_PER_SECOND = n4;
    }
}

