/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.InternalContext;
import java.lang.annotation.Annotation;
import ru.vyarus.guice.ext.core.generator.DynamicClassGenerator;
import ru.vyarus.guice.ext.core.generator.anchor.AnchorBean;

@Singleton
public class DynamicClassProvider
implements Provider<Object> {
    private final Injector injector;

    @Inject
    public DynamicClassProvider(Injector injector) {
        this.injector = injector;
    }

    public Object get() {
        try (InternalContext context = ((InjectorImpl)this.injector).enterContext();){
            boolean hasAnchor = this.injector.getExistingBinding(Key.get(AnchorBean.class)) != null;
            Class abstractType = context.getDependency().getKey().getTypeLiteral().getRawType();
            Class generatedType = DynamicClassGenerator.generate(abstractType, this.getScopeAnnotation(), hasAnchor ? AnchorBean.class : null);
            Object object = this.injector.getInstance(generatedType);
            return object;
        }
    }

    protected Class<? extends Annotation> getScopeAnnotation() {
        return null;
    }
}

