/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.validator.group;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Singleton;
import javax.validation.groups.Default;
import ru.vyarus.guice.validator.group.GroupAction;

@Singleton
public class ValidationContext {
    private static final Class<?>[] EMPTY = new Class[0];
    private final ThreadLocal<List<Class<?>[]>> threadContext = new ThreadLocal();

    public Class<?>[] getContextGroups() {
        Class<?>[] res = EMPTY;
        List<Class<?>[]> context = this.threadContext.get();
        if (context != null) {
            res = context.get(context.size() - 1);
        }
        return res;
    }

    public <T> T doWithGroups(GroupAction<T> action, Class<?> ... groups) {
        this.pushContext(groups);
        try {
            T t = action.call();
            return t;
        }
        catch (Throwable ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        finally {
            this.popContext();
        }
    }

    private void pushContext(Class<?>[] groups) {
        List<Class<?>[]> context = this.threadContext.get();
        if (context == null) {
            context = new ArrayList<Class<?>[]>();
            this.threadContext.set(context);
        }
        LinkedHashSet allgroups = new LinkedHashSet();
        if (!context.isEmpty()) {
            Collections.addAll(allgroups, (Object[])context.get(context.size() - 1));
            allgroups.remove(Default.class);
        }
        Collections.addAll(allgroups, groups);
        context.add(allgroups.toArray(new Class[allgroups.size()]));
    }

    private void popContext() {
        List<Class<?>[]> context = this.threadContext.get();
        if (context.size() > 1) {
            context.remove(context.size() - 1);
        } else {
            this.threadContext.remove();
        }
    }
}

