/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.validator.group.annotation;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import ru.vyarus.guice.validator.group.annotation.ValidationGroups;

public final class GroupUtils {
    private GroupUtils() {
    }

    public static List<ValidationGroups> findAnnotations(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        List<ValidationGroups> annotations = GroupUtils.filterAnnotations(declaringClass.getAnnotations());
        annotations.addAll(GroupUtils.filterAnnotations(method.getAnnotations()));
        return annotations;
    }

    private static List<ValidationGroups> filterAnnotations(Annotation ... annotations) {
        ArrayList res = Lists.newArrayList();
        for (Annotation ann : annotations) {
            if (ValidationGroups.class.equals(ann.annotationType())) {
                res.add((ValidationGroups)ann);
                continue;
            }
            if (!ann.annotationType().isAnnotationPresent(ValidationGroups.class)) continue;
            res.add(ann.annotationType().getAnnotation(ValidationGroups.class));
        }
        return res;
    }
}

