/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.validator.group.annotation;

import com.google.common.base.Preconditions;
import com.google.inject.name.Named;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.groups.Default;
import ru.vyarus.guice.validator.group.annotation.GroupUtils;
import ru.vyarus.guice.validator.group.annotation.ValidationGroups;

@Singleton
public class MethodGroupsFactory {
    public static final String CACHE_PROPERTY = MethodGroupsFactory.class.getName() + ".cache";
    private static final ReentrantLock LOCK = new ReentrantLock();
    private final Map<Method, Class<?>[]> cache = new HashMap<Method, Class<?>[]>();
    private final boolean addDefaultGroup;

    @Inject
    public MethodGroupsFactory(@Named(value="guice.validator.addDefaultGroup") boolean addDefaultGroup) {
        this.addDefaultGroup = addDefaultGroup;
    }

    public Class<?>[] create(Method method) {
        Class<?>[] groups = this.cache.get(method);
        if (groups == null) {
            LOCK.lock();
            try {
                groups = this.cache.get(method);
                if (groups == null) {
                    groups = this.buildGroups(method);
                    if (MethodGroupsFactory.isCacheEnabled()) {
                        Preconditions.checkState((this.cache.get(method) == null ? 1 : 0) != 0, (Object)"Bad concurrency: groups already present in cache");
                        this.cache.put(method, groups);
                    }
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return groups;
    }

    private Class<?>[] buildGroups(Method method) {
        List<ValidationGroups> annotations = GroupUtils.findAnnotations(method);
        LinkedHashSet<Class<Default>> result = new LinkedHashSet<Class<Default>>();
        for (ValidationGroups group : annotations) {
            Collections.addAll(result, group.value());
        }
        if (this.addDefaultGroup) {
            result.add(Default.class);
        }
        return result.toArray(new Class[0]);
    }

    public void clearCache() {
        LOCK.lock();
        try {
            this.cache.clear();
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void disableCache() {
        System.setProperty(CACHE_PROPERTY, Boolean.FALSE.toString());
    }

    public static boolean isCacheEnabled() {
        String no = Boolean.FALSE.toString();
        return !no.equals(System.getenv(CACHE_PROPERTY)) && !no.equals(System.getProperty(CACHE_PROPERTY));
    }
}

