/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.validator;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.executable.ValidateOnExecution;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import ru.vyarus.guice.validator.aop.DeclaredMethodMatcher;
import ru.vyarus.guice.validator.aop.ValidatedMethodMatcher;
import ru.vyarus.guice.validator.aop.ValidationMethodInterceptor;
import ru.vyarus.guice.validator.constraint.GuiceConstraintValidatorFactory;
import ru.vyarus.guice.validator.group.ValidationContext;
import ru.vyarus.guice.validator.group.aop.ValidationGroupInterceptor;
import ru.vyarus.guice.validator.group.aop.ValidationGroupMatcher;

public class ValidationModule
extends AbstractModule {
    public static final Matcher<Method> DECLARED_METHOD_MATCHER = new DeclaredMethodMatcher();
    private final ValidatorFactory factory;
    private Matcher<? super Class<?>> classMatcher = Matchers.any();
    private Matcher<? super Method> methodMatcher = DECLARED_METHOD_MATCHER;
    private Class<? extends Annotation> validationAnnotation;
    private boolean addDefaultGroup = true;

    public ValidationModule() {
        this(Validation.buildDefaultValidatorFactory());
    }

    public ValidationModule(ValidatorFactory factory) {
        this.factory = factory;
    }

    public ValidationModule strictGroupsDeclaration() {
        this.addDefaultGroup = false;
        return this;
    }

    public ValidationModule validateAnnotatedOnly() {
        return this.validateAnnotatedOnly(ValidateOnExecution.class);
    }

    public ValidationModule validateAnnotatedOnly(Class<? extends Annotation> annotation) {
        this.validationAnnotation = annotation;
        return this;
    }

    public ValidationModule targetClasses(Matcher<? super Class<?>> classMatcher) {
        this.classMatcher = classMatcher;
        return this;
    }

    public ValidationModule targetMethods(Matcher<? super Method> methodMatcher) {
        this.methodMatcher = methodMatcher;
        return this;
    }

    protected void configure() {
        GuiceConstraintValidatorFactory constraintValidatorFactory = new GuiceConstraintValidatorFactory();
        this.requestInjection(constraintValidatorFactory);
        Validator validator = this.factory.usingContext().constraintValidatorFactory((ConstraintValidatorFactory)constraintValidatorFactory).getValidator();
        this.bind(Validator.class).toInstance((Object)validator);
        this.bind(ExecutableValidator.class).toInstance((Object)validator.forExecutables());
        this.bind(ValidatorFactory.class).toInstance((Object)this.factory);
        this.bind(ValidationContext.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"guice.validator.addDefaultGroup")).to(this.addDefaultGroup);
        ValidationGroupInterceptor groupInterceptor = new ValidationGroupInterceptor();
        this.requestInjection(groupInterceptor);
        this.configureGroupsAop(groupInterceptor);
        ValidationMethodInterceptor interceptor = new ValidationMethodInterceptor();
        this.requestInjection(interceptor);
        this.configureAop(interceptor);
    }

    protected void configureGroupsAop(ValidationGroupInterceptor interceptor) {
        this.bindInterceptor(Matchers.any(), (Matcher)new ValidationGroupMatcher(), new MethodInterceptor[]{interceptor});
    }

    protected void configureAop(ValidationMethodInterceptor interceptor) {
        if (this.validationAnnotation != null) {
            this.bindInterceptor(this.classMatcher, this.getMethodMatcher(this.validationAnnotation), new MethodInterceptor[]{interceptor});
            this.bindInterceptor(this.getClassMatcher(this.validationAnnotation), this.methodMatcher, new MethodInterceptor[]{interceptor});
        } else {
            this.bindInterceptor(this.classMatcher, this.getValidatedMethodMatcher(), new MethodInterceptor[]{interceptor});
        }
    }

    protected Matcher<? super Class<?>> getClassMatcher(Class<? extends Annotation> annotation) {
        Matcher res = Matchers.annotatedWith(annotation);
        return this.classMatcher == Matchers.any() ? res : res.and(this.classMatcher);
    }

    protected Matcher<? super Method> getMethodMatcher(Class<? extends Annotation> annotation) {
        Matcher res = Matchers.annotatedWith(annotation);
        return this.methodMatcher == DECLARED_METHOD_MATCHER ? res : res.and(this.methodMatcher);
    }

    protected Matcher<? super Method> getValidatedMethodMatcher() {
        ValidatedMethodMatcher res = new ValidatedMethodMatcher();
        return this.methodMatcher == Matchers.any() ? res : res.and(this.methodMatcher);
    }
}

