/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guice.validator.aop;

import com.google.inject.matcher.AbstractMatcher;
import jakarta.validation.Constraint;
import jakarta.validation.Valid;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class ValidatedMethodMatcher
extends AbstractMatcher<Method> {
    public boolean matches(Method method) {
        boolean matches = this.isValidationAnnotations(method.getAnnotations());
        if (!matches) {
            for (Annotation[] annotations : method.getParameterAnnotations()) {
                if (!this.isValidationAnnotations(annotations)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    private boolean isValidationAnnotations(Annotation ... annotations) {
        boolean matches = false;
        for (Annotation ann : annotations) {
            Class<? extends Annotation> annotationType = ann.annotationType();
            if (!Valid.class.equals(annotationType) && !annotationType.isAnnotationPresent(Constraint.class)) continue;
            matches = true;
            break;
        }
        return matches;
    }
}

