/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi.module;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import ru.vyarus.guicey.jdbi.module.MapperBinder;
import ru.vyarus.guicey.jdbi.module.NoSyntheticMatcher;
import ru.vyarus.guicey.jdbi.tx.TransactionTemplate;
import ru.vyarus.guicey.jdbi.tx.aop.TransactionalInterceptor;
import ru.vyarus.guicey.jdbi.unit.UnitManager;

public class JdbiModule
extends AbstractModule {
    private final DBI jdbi;
    private final List<Class<? extends Annotation>> txAnnotations;

    public JdbiModule(DBI jdbi, List<Class<? extends Annotation>> txAnnotations) {
        Preconditions.checkState((!txAnnotations.isEmpty() ? 1 : 0) != 0, (Object)"Provide at least one transactional annotation");
        this.jdbi = jdbi;
        this.txAnnotations = txAnnotations;
    }

    protected void configure() {
        this.bind(DBI.class).toInstance((Object)this.jdbi);
        Multibinder.newSetBinder((Binder)this.binder(), ResultSetMapper.class);
        this.bind(MapperBinder.class).asEagerSingleton();
        this.bind(UnitManager.class);
        this.bind(Handle.class).toProvider(UnitManager.class);
        this.bind(TransactionTemplate.class);
        this.bindAnnotationsSupport();
    }

    private void bindAnnotationsSupport() {
        TransactionalInterceptor interceptor = new TransactionalInterceptor();
        this.requestInjection(interceptor);
        this.txAnnotations.forEach(it -> {
            this.bindInterceptor(Matchers.annotatedWith((Class)it), (Matcher)NoSyntheticMatcher.instance(), new MethodInterceptor[]{interceptor});
            this.bindInterceptor(Matchers.any(), Matchers.annotatedWith((Class)it), new MethodInterceptor[]{interceptor});
        });
    }
}

