/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3.installer.repository;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Stage;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Singleton;
import org.aopalliance.intercept.MethodInterceptor;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelUtils;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.guice.ext.core.generator.DynamicClassGenerator;
import ru.vyarus.guicey.jdbi3.installer.repository.JdbiRepository;
import ru.vyarus.guicey.jdbi3.installer.repository.sql.SqlObjectProvider;
import ru.vyarus.guicey.jdbi3.module.NoSyntheticMatcher;
import ru.vyarus.java.generics.resolver.GenericsResolver;

public class RepositoryInstaller
implements FeatureInstaller,
BindingInstaller {
    private final Reporter reporter = new Reporter(RepositoryInstaller.class, "repositories = ");

    public boolean matches(Class<?> type) {
        boolean res;
        boolean bl = res = type.getAnnotation(JdbiRepository.class) != null;
        if (res) {
            this.validateCorrectness(type);
        }
        return res;
    }

    public void bind(Binder binder, Class<?> type, boolean lazy) {
        Preconditions.checkState((!lazy ? 1 : 0) != 0, (Object)"@LazyBinding not supported");
        SqlObjectProvider jdbiProxy = new SqlObjectProvider(type);
        binder.requestInjection(jdbiProxy);
        Class guiceType = DynamicClassGenerator.generate(type);
        binder.bind(type).to(guiceType).in(Singleton.class);
        binder.bindInterceptor(Matchers.subclassesOf(type), (Matcher)NoSyntheticMatcher.instance(), new MethodInterceptor[]{invocation -> {
            try {
                return invocation.getMethod().invoke(jdbiProxy.get(), invocation.getArguments());
            }
            catch (InvocationTargetException th) {
                throw th.getCause();
            }
        }});
    }

    public <T> void manualBinding(Binder binder, Class<T> type, Binding<T> binding) {
        throw new UnsupportedOperationException(String.format("JDBI repository %s can't be installed from binding: %s", type.getSimpleName(), GuiceModelUtils.getDeclarationSource(binding).toString()));
    }

    public void extensionBound(Stage stage, Class<?> type) {
        if (stage != Stage.TOOL) {
            this.reporter.line(String.format("(%s)", type.getName()), new Object[0]);
        }
    }

    public void report() {
        this.reporter.report();
    }

    private void validateCorrectness(Class<?> type) {
        for (Class check : GenericsResolver.resolve(type, (Class[])new Class[0]).getGenericsInfo().getComposingTypes()) {
            if (check.equals(type) || !check.isAnnotationPresent(JdbiRepository.class)) continue;
            throw new IllegalStateException(String.format("Incorrect repository %s declaration: base interface %s is also annotated with @%s which may break AOP mappings. Only root repository class must be annotated.", type.getSimpleName(), check.getSimpleName(), JdbiRepository.class.getSimpleName()));
        }
    }
}

