/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.db.PooledDataSourceFactory;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import ru.vyarus.dropwizard.guice.module.context.unique.item.UniqueGuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.guicey.jdbi3.dbi.ConfigAwareProvider;
import ru.vyarus.guicey.jdbi3.dbi.SimpleDbiProvider;
import ru.vyarus.guicey.jdbi3.installer.MapperInstaller;
import ru.vyarus.guicey.jdbi3.installer.repository.RepositoryInstaller;
import ru.vyarus.guicey.jdbi3.module.JdbiModule;
import ru.vyarus.guicey.jdbi3.tx.InTransaction;

public final class JdbiBundle
extends UniqueGuiceyBundle {
    private final ConfigAwareProvider<Jdbi, ?> jdbi;
    private List<Class<? extends Annotation>> txAnnotations = ImmutableList.builder().add(InTransaction.class).build();
    private List<JdbiPlugin> plugins = Collections.emptyList();
    private Consumer<Jdbi> configurer;

    private JdbiBundle(ConfigAwareProvider<Jdbi, ?> jdbi) {
        this.jdbi = jdbi;
    }

    @SafeVarargs
    public final JdbiBundle withTxAnnotations(Class<? extends Annotation> ... txAnnotations) {
        this.txAnnotations = Lists.newArrayList((Object[])txAnnotations);
        return this;
    }

    public JdbiBundle withPlugins(JdbiPlugin ... plugins) {
        this.plugins = Arrays.asList(plugins);
        return this;
    }

    public JdbiBundle withConfig(Consumer<Jdbi> configurer) {
        this.configurer = configurer;
        return this;
    }

    public void initialize(GuiceyBootstrap bootstrap) {
        bootstrap.installers(new Class[]{RepositoryInstaller.class, MapperInstaller.class});
    }

    public void run(GuiceyEnvironment environment) {
        Jdbi jdbi = this.jdbi.get(environment.configuration(), environment.environment());
        this.plugins.forEach(arg_0 -> ((Jdbi)jdbi).installPlugin(arg_0));
        if (this.configurer != null) {
            this.configurer.accept(jdbi);
        }
        environment.modules(new Module[]{new JdbiModule(jdbi, this.txAnnotations)});
    }

    public static <C extends Configuration> JdbiBundle forDbi(ConfigAwareProvider<Jdbi, C> dbi) {
        return new JdbiBundle(dbi);
    }

    public static <C extends Configuration> JdbiBundle forDatabase(ConfigAwareProvider<PooledDataSourceFactory, C> db) {
        return JdbiBundle.forDbi(new SimpleDbiProvider<C>(db));
    }
}

