/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3.inject;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;

public class InjectionHandlerFactory
implements HandlerFactory {
    @javax.inject.Inject
    private Injector injector;

    public Optional<Handler> buildHandler(Class<?> sqlObjectType, Method method) {
        if (method.getAnnotation(javax.inject.Inject.class) != null || method.getAnnotation(Inject.class) != null) {
            return Optional.of(new InjectionHandler(this.injector, method.getReturnType()));
        }
        return Optional.empty();
    }

    private static class InjectionHandler
    implements Handler {
        private final Injector injector;
        private final Class<?> type;

        InjectionHandler(Injector injector, Class<?> type) {
            this.injector = (Injector)Preconditions.checkNotNull((Object)injector, (Object)"No injector");
            this.type = (Class)Preconditions.checkNotNull(type, (Object)"No type");
            Preconditions.checkState((type != Void.class && type != Void.TYPE ? 1 : 0) != 0, (Object)"Only non void (getter) method could be anotated with @Inject in orderto provide guice bean.");
        }

        public Object invoke(Object target, Object[] args, HandleSupplier handle) throws Exception {
            return this.injector.getInstance(this.type);
        }
    }
}

