/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3.module;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Stage;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.TransactionalHandleSupplier;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.Handlers;
import ru.vyarus.guicey.jdbi3.inject.InjectionHandlerFactory;
import ru.vyarus.guicey.jdbi3.module.MapperBinder;
import ru.vyarus.guicey.jdbi3.module.NoSyntheticMatcher;
import ru.vyarus.guicey.jdbi3.tx.TransactionTemplate;
import ru.vyarus.guicey.jdbi3.tx.aop.TransactionalInterceptor;
import ru.vyarus.guicey.jdbi3.unit.UnitManager;

public class JdbiModule
extends AbstractModule {
    private final Jdbi jdbi;
    private final List<Class<? extends Annotation>> txAnnotations;

    public JdbiModule(Jdbi jdbi, List<Class<? extends Annotation>> txAnnotations) {
        Preconditions.checkState((!txAnnotations.isEmpty() ? 1 : 0) != 0, (Object)"Provide at least one transactional annotation");
        this.jdbi = jdbi;
        this.txAnnotations = txAnnotations;
    }

    protected void configure() {
        if (this.binder().currentStage() != Stage.TOOL) {
            InjectionHandlerFactory gettersInjector = new InjectionHandlerFactory();
            this.requestInjection(gettersInjector);
            ((Handlers)this.jdbi.getConfig(Handlers.class)).register((HandlerFactory)gettersInjector);
        }
        this.bind(Jdbi.class).toInstance((Object)this.jdbi);
        Multibinder.newSetBinder((Binder)this.binder(), RowMapper.class);
        this.bind(MapperBinder.class).asEagerSingleton();
        this.bind(UnitManager.class);
        this.bind(Handle.class).toProvider(UnitManager.class);
        this.bind(TransactionalHandleSupplier.class);
        this.bind(TransactionTemplate.class);
        this.bindAnnotationsSupport();
    }

    private void bindAnnotationsSupport() {
        TransactionalInterceptor interceptor = new TransactionalInterceptor(this.txAnnotations);
        this.requestInjection(interceptor);
        this.txAnnotations.forEach(it -> {
            this.bindInterceptor(Matchers.annotatedWith((Class)it), (Matcher)NoSyntheticMatcher.instance(), new MethodInterceptor[]{interceptor});
            this.bindInterceptor(Matchers.any(), Matchers.annotatedWith((Class)it), new MethodInterceptor[]{interceptor});
        });
    }
}

