/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.jdbi3.tx.aop;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import ru.vyarus.guicey.jdbi3.tx.TransactionTemplate;
import ru.vyarus.guicey.jdbi3.tx.TxConfig;
import ru.vyarus.guicey.jdbi3.tx.aop.config.TxConfigFactory;
import ru.vyarus.guicey.jdbi3.tx.aop.config.TxConfigSupport;

public class TransactionalInterceptor
implements MethodInterceptor {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private final Map<Class<? extends Annotation>, Class<? extends TxConfigFactory>> txConfigFactories = new HashMap<Class<? extends Annotation>, Class<? extends TxConfigFactory>>();
    private final Map<String, TxConfig> methodCache = new HashMap<String, TxConfig>();
    @Inject
    private TransactionTemplate template;
    @Inject
    private Injector injector;

    public TransactionalInterceptor(List<Class<? extends Annotation>> txAnnotations) {
        this.findConfigurableAnnotations(txAnnotations);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        TxConfig config = this.checkTxConfig(invocation.getMethod());
        return this.template.inTransaction(config, handle -> {
            try {
                return invocation.proceed();
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
        });
    }

    private void findConfigurableAnnotations(List<Class<? extends Annotation>> txAnnotations) {
        for (Class<? extends Annotation> ann : txAnnotations) {
            if (!ann.isAnnotationPresent(TxConfigSupport.class)) continue;
            this.txConfigFactories.put(ann, ann.getAnnotation(TxConfigSupport.class).value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxConfig checkTxConfig(Method method) {
        String methodIdentity = (method.getDeclaringClass().getName() + " " + method.toString()).intern();
        TxConfig cfg = this.methodCache.get(methodIdentity);
        if (cfg == null) {
            LOCK.lock();
            try {
                if (this.methodCache.get(methodIdentity) != null) {
                    cfg = this.methodCache.get(methodIdentity);
                } else {
                    cfg = this.buildConfig(method);
                    this.methodCache.put(methodIdentity, cfg);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return cfg;
    }

    private TxConfig buildConfig(Method method) {
        TxConfig res = null;
        if (!this.txConfigFactories.isEmpty()) {
            Annotation txAnn = this.findAnnotation(method, this.txConfigFactories.keySet());
            if (txAnn == null) {
                txAnn = this.findAnnotation(method.getDeclaringClass(), this.txConfigFactories.keySet());
            }
            if (txAnn != null) {
                TxConfigFactory factory = (TxConfigFactory)this.injector.getInstance(this.txConfigFactories.get(txAnn.annotationType()));
                res = factory.build(txAnn);
            }
        }
        return res == null ? new TxConfig() : res;
    }

    private Annotation findAnnotation(AnnotatedElement obj, Collection<Class<? extends Annotation>> anns) {
        for (Class<? extends Annotation> ann : anns) {
            if (!obj.isAnnotationPresent(ann)) continue;
            return obj.getAnnotation(ann);
        }
        return null;
    }
}

