/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.sourceforge.argparse4j.inf.Namespace;
import org.junit.rules.ExternalResource;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.test.TestCommand;

public class GuiceyAppRule<C extends Configuration>
extends ExternalResource {
    private final Class<? extends Application<C>> applicationClass;
    private final String configPath;
    private final List<ConfigOverride> configOverrides;
    private C configuration;
    private Application<C> application;
    private Environment environment;
    private TestCommand<C> command;

    public GuiceyAppRule(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigOverride ... configOverrides) {
        this.applicationClass = applicationClass;
        this.configPath = configPath;
        this.configOverrides = Arrays.asList(configOverrides);
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public <A extends Application<C>> A getApplication() {
        return (A)this.application;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Injector getInjector() {
        return (Injector)InjectorLookup.getInjector(this.application).get();
    }

    public <T> T getBean(Class<T> type) {
        return (T)this.getInjector().getInstance(type);
    }

    protected Application<C> newApplication() {
        try {
            return this.applicationClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate application", e);
        }
    }

    protected void before() throws Throwable {
        for (ConfigOverride configOverride : this.configOverrides) {
            configOverride.addToSystemProperties();
        }
        this.startIfRequired();
    }

    protected void after() {
        this.resetConfigOverrides();
        this.command.stop();
        this.command = null;
    }

    private void startIfRequired() {
        if (this.command != null) {
            return;
        }
        try {
            this.application = this.newApplication();
            Bootstrap bootstrap = new Bootstrap<C>(this.application){

                public void run(C configuration, Environment environment) throws Exception {
                    GuiceyAppRule.this.configuration = configuration;
                    GuiceyAppRule.this.environment = environment;
                    super.run(configuration, environment);
                }
            };
            this.application.initialize(bootstrap);
            this.startCommand(bootstrap);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start test environment", e);
        }
    }

    private void startCommand(Bootstrap<C> bootstrap) throws Exception {
        this.command = new TestCommand(this.application);
        ImmutableMap.Builder file = ImmutableMap.builder();
        if (!Strings.isNullOrEmpty((String)this.configPath)) {
            file.put((Object)"file", (Object)this.configPath);
        }
        Namespace namespace = new Namespace((Map)file.build());
        this.command.run(bootstrap, namespace);
    }

    private void resetConfigOverrides() {
        Enumeration<?> props = System.getProperties().propertyNames();
        while (props.hasMoreElements()) {
            String keyString = (String)props.nextElement();
            if (!keyString.startsWith("dw.")) continue;
            System.clearProperty(keyString);
        }
    }
}

