/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.spock.jupiter;

import java.lang.reflect.Executable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import ru.vyarus.spock.jupiter.engine.ExtensionRegistry;
import ru.vyarus.spock.jupiter.engine.ExtensionUtils;
import ru.vyarus.spock.jupiter.engine.context.ClassContext;
import ru.vyarus.spock.jupiter.engine.execution.ConditionEvaluator;
import ru.vyarus.spock.jupiter.interceptor.ExtensionLifecycleMerger;

public class JunitExtensionSupport
implements IGlobalExtension {
    public void visitSpec(SpecInfo spec) {
        Class testClass = (Class)spec.getReflection();
        ExtensionRegistry registry = ExtensionUtils.createRegistry(testClass);
        ExtensionUtils.registerExtensionsFromFields(registry, testClass, null);
        spec.getAllFixtureMethods().forEach(methodInfo -> ExtensionUtils.registerExtensionsFromExecutableParameters(registry, (Executable)methodInfo.getReflection()));
        ClassContext specContext = new ClassContext(registry, spec);
        spec.addInterceptor(invocation -> {
            if (ConditionEvaluator.skip((ISkippable)spec, specContext)) {
                return;
            }
            invocation.proceed();
        });
        ExtensionLifecycleMerger interceptor = new ExtensionLifecycleMerger(specContext);
        spec.addSetupSpecInterceptor((IMethodInterceptor)interceptor);
        spec.addInitializerInterceptor((IMethodInterceptor)interceptor);
        spec.addSetupInterceptor((IMethodInterceptor)interceptor);
        spec.addCleanupInterceptor((IMethodInterceptor)interceptor);
        spec.addCleanupSpecInterceptor((IMethodInterceptor)interceptor);
        spec.getAllFixtureMethods().forEach(methodInfo -> methodInfo.addInterceptor(interceptor.getFixtureMethodsInterceptor()));
        spec.getAllFeatures().forEach(featureInfo -> featureInfo.getFeatureMethod().addInterceptor((IMethodInterceptor)interceptor));
    }

    public static ExtensionContext.Store getStore(SpecInfo spec, ExtensionContext.Namespace namespace) {
        return JunitExtensionSupport.findInterceptor(spec).getSpecContext().getStore(namespace);
    }

    public static ExtensionContext.Store getStore(IMethodInvocation invocation, ExtensionContext.Namespace namespace) {
        return invocation.getMethod().getKind() == MethodKind.INITIALIZER || invocation.getFeature() == null || invocation.getInstance() == null ? JunitExtensionSupport.getStore(invocation.getSpec(), namespace) : JunitExtensionSupport.findInterceptor(invocation.getSpec()).getMethodContext(invocation).getStore(namespace);
    }

    private static ExtensionLifecycleMerger findInterceptor(SpecInfo spec) {
        return (ExtensionLifecycleMerger)spec.getSetupSpecInterceptors().stream().filter(interceptor -> interceptor instanceof ExtensionLifecycleMerger).findFirst().orElseThrow(() -> new NullPointerException("Junit support not found in spec: " + spec.getDisplayName()));
    }
}

