/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.spock.jupiter.engine.execution;

import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.StringUtils;
import org.spockframework.runtime.model.ISkippable;
import ru.vyarus.spock.jupiter.engine.ExtensionRegistry;
import ru.vyarus.spock.jupiter.engine.context.AbstractContext;
import ru.vyarus.spock.jupiter.engine.execution.ConditionEvaluationException;

public final class ConditionEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConditionEvaluator.class);
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"No 'disabled' conditions encountered");

    private ConditionEvaluator() {
    }

    public static boolean skip(ISkippable test, AbstractContext context) {
        ConditionEvaluationResult execution = ConditionEvaluator.evaluate(context.getRegistry(), context);
        if (execution.isDisabled()) {
            test.skip(execution.getReason().orElse("<unknown>"));
            return true;
        }
        return false;
    }

    public static ConditionEvaluationResult evaluate(ExtensionRegistry extensionRegistry, ExtensionContext context) {
        return extensionRegistry.stream(ExecutionCondition.class).map(condition -> ConditionEvaluator.evaluateImpl(condition, context)).filter(ConditionEvaluationResult::isDisabled).findFirst().orElse(ENABLED);
    }

    private static ConditionEvaluationResult evaluateImpl(ExecutionCondition condition, ExtensionContext context) {
        try {
            ConditionEvaluationResult result = condition.evaluateExecutionCondition(context);
            ConditionEvaluator.logResult(condition.getClass(), result, context);
            return result;
        }
        catch (Exception ex) {
            throw ConditionEvaluator.evaluationException(condition.getClass(), ex);
        }
    }

    private static void logResult(Class<?> conditionType, ConditionEvaluationResult result, ExtensionContext context) {
        LOGGER.trace(() -> String.format("Evaluation of condition [%s] on [%s] resulted in: %s", conditionType.getName(), context.getElement().get(), result));
    }

    private static ConditionEvaluationException evaluationException(Class<?> conditionType, Exception ex) {
        String cause = StringUtils.isNotBlank((String)ex.getMessage()) ? ": " + ex.getMessage() : "";
        return new ConditionEvaluationException(String.format("Failed to evaluate condition [%s]%s", conditionType.getName(), cause), ex);
    }
}

