/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.spock.jupiter.engine.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.platform.commons.util.ReflectionUtils;
import org.spockframework.runtime.model.MethodInfo;
import ru.vyarus.spock.jupiter.engine.ExtensionUtils;
import ru.vyarus.spock.jupiter.engine.context.AbstractContext;
import ru.vyarus.spock.jupiter.engine.context.DefaultParameterContext;

public class DefaultExecutableInvoker
implements ExecutableInvoker {
    private final AbstractContext context;

    public DefaultExecutableInvoker(AbstractContext context) {
        this.context = context;
    }

    public <T> T invoke(Constructor<T> constructor, Object outerInstance) {
        Object[] arguments = this.collectArguments(constructor, null, outerInstance != null ? 1 : 0);
        if (outerInstance != null) {
            arguments[0] = outerInstance;
        }
        return (T)ReflectionUtils.newInstance(constructor, (Object[])arguments);
    }

    public Object invoke(Method method, Object target) {
        Object[] arguments = this.collectArguments(method, target, 0);
        return ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])arguments);
    }

    private Object[] collectArguments(Executable executable, Object target, int start) {
        Parameter[] parameters = executable.getParameters();
        if (parameters.length == 0) {
            return new Object[0];
        }
        Object[] arguments = new Object[parameters.length];
        Optional<Object> targetOptional = Optional.ofNullable(target);
        for (int i = start; i < arguments.length; ++i) {
            Parameter param = parameters[i];
            DefaultParameterContext parameterContext = new DefaultParameterContext(param, i, targetOptional);
            arguments[i] = ExtensionUtils.resolveParameter(parameterContext, executable, this.context);
            if (arguments[i] != MethodInfo.MISSING_ARGUMENT) continue;
            throw new ParameterResolutionException(String.format("No ParameterResolver registered for parameter [%s] in %s [%s].", parameterContext.getParameter(), ExtensionUtils.asLabel(executable), executable.toGenericString()));
        }
        return arguments;
    }
}

