/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.spock.jupiter.engine.store;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class ExtensionValuesStore {
    private static final Comparator<StoredValue> REVERSE_INSERT_ORDER = Comparator.comparing(it -> StoredValue.access$500(it)).reversed();
    private final AtomicInteger insertOrderSequence = new AtomicInteger();
    private final ConcurrentMap<CompositeKey, StoredValue> storedValues = new ConcurrentHashMap<CompositeKey, StoredValue>(4);
    private final ExtensionValuesStore parentStore;

    public ExtensionValuesStore(ExtensionValuesStore parentStore) {
        this.parentStore = parentStore;
    }

    public void closeAllStoredCloseableValues() {
        OpenTest4JAwareThrowableCollector throwableCollector = new OpenTest4JAwareThrowableCollector();
        this.storedValues.values().stream().filter(storedValue -> ((StoredValue)storedValue).evaluateSafely() instanceof ExtensionContext.Store.CloseableResource).sorted(REVERSE_INSERT_ORDER).map(storedValue -> (ExtensionContext.Store.CloseableResource)((StoredValue)storedValue).evaluate()).forEach(arg_0 -> ExtensionValuesStore.lambda$closeAllStoredCloseableValues$3((ThrowableCollector)throwableCollector, arg_0));
        throwableCollector.assertEmpty();
    }

    protected Object get(ExtensionContext.Namespace namespace, Object key) {
        StoredValue storedValue = this.getStoredValue(new CompositeKey(namespace, key));
        return storedValue != null ? storedValue.evaluate() : null;
    }

    protected <T> T get(ExtensionContext.Namespace namespace, Object key, Class<T> requiredType) {
        Object value = this.get(namespace, key);
        return this.castToRequiredType(key, value, requiredType);
    }

    protected <K, V> Object getOrComputeIfAbsent(ExtensionContext.Namespace namespace, K key, Function<K, V> defaultCreator) {
        CompositeKey compositeKey = new CompositeKey(namespace, key);
        StoredValue storedValue = this.getStoredValue(compositeKey);
        if (storedValue == null) {
            StoredValue newValue = this.storedValue(new MemoizingSupplier(() -> defaultCreator.apply(key)));
            storedValue = Optional.ofNullable(this.storedValues.putIfAbsent(compositeKey, newValue)).orElse(newValue);
        }
        return storedValue.evaluate();
    }

    protected <K, V> V getOrComputeIfAbsent(ExtensionContext.Namespace namespace, K key, Function<K, V> defaultCreator, Class<V> requiredType) {
        Object value = this.getOrComputeIfAbsent(namespace, key, defaultCreator);
        return this.castToRequiredType(key, value, requiredType);
    }

    protected void put(ExtensionContext.Namespace namespace, Object key, Object value) {
        this.storedValues.put(new CompositeKey(namespace, key), this.storedValue(() -> value));
    }

    private StoredValue storedValue(Supplier<Object> value) {
        return new StoredValue(this.insertOrderSequence.getAndIncrement(), value);
    }

    protected Object remove(ExtensionContext.Namespace namespace, Object key) {
        StoredValue previous = (StoredValue)this.storedValues.remove(new CompositeKey(namespace, key));
        return previous != null ? previous.evaluate() : null;
    }

    protected <T> T remove(ExtensionContext.Namespace namespace, Object key, Class<T> requiredType) {
        Object value = this.remove(namespace, key);
        return this.castToRequiredType(key, value, requiredType);
    }

    private StoredValue getStoredValue(CompositeKey compositeKey) {
        StoredValue storedValue = (StoredValue)this.storedValues.get(compositeKey);
        if (storedValue == null && this.parentStore != null) {
            storedValue = this.parentStore.getStoredValue(compositeKey);
        }
        return storedValue;
    }

    private <T> T castToRequiredType(Object key, Object value, Class<T> requiredType) {
        if (value == null) {
            return null;
        }
        if (ReflectionUtils.isAssignableTo((Object)value, requiredType)) {
            T res = requiredType.isPrimitive() ? ReflectionUtils.getWrapperType(requiredType).cast(value) : requiredType.cast(value);
            return res;
        }
        throw new ExtensionContextException(String.format("Object stored under key [%s] is not of required type [%s]", key, requiredType.getName()));
    }

    private static /* synthetic */ void lambda$closeAllStoredCloseableValues$3(ThrowableCollector throwableCollector, ExtensionContext.Store.CloseableResource resource) {
        throwableCollector.execute(() -> ((ExtensionContext.Store.CloseableResource)resource).close());
    }

    private static final class MemoizingSupplier
    implements Supplier<Object> {
        private static final Object NO_VALUE_SET = new Object();
        private final Lock lock = new ReentrantLock();
        private final Supplier<Object> delegate;
        private volatile Object value = NO_VALUE_SET;

        private MemoizingSupplier(Supplier<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object get() {
            if (this.value == NO_VALUE_SET) {
                this.computeValue();
            }
            if (this.value instanceof Failure) {
                throw ((Failure)this.value).exception;
            }
            return this.value;
        }

        private void computeValue() {
            this.lock.lock();
            try {
                if (this.value == NO_VALUE_SET) {
                    this.value = this.delegate.get();
                }
            }
            catch (RuntimeException e) {
                this.value = new Failure(e);
            }
            finally {
                this.lock.unlock();
            }
        }

        private static class Failure {
            private final RuntimeException exception;

            Failure(RuntimeException exception) {
                this.exception = exception;
            }
        }
    }

    private static class StoredValue {
        private final int order;
        private final Supplier<Object> supplier;

        StoredValue(int order, Supplier<Object> supplier) {
            this.order = order;
            this.supplier = supplier;
        }

        private Object evaluateSafely() {
            try {
                return this.evaluate();
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        private Object evaluate() {
            return this.supplier.get();
        }
    }

    private static final class CompositeKey {
        private final ExtensionContext.Namespace namespace;
        private final Object key;

        private CompositeKey(ExtensionContext.Namespace namespace, Object key) {
            this.namespace = namespace;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            return this.namespace.equals((Object)that.namespace) && this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.key);
        }
    }
}

