/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.spock.jupiter.interceptor;

import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import ru.vyarus.spock.jupiter.engine.context.AbstractContext;
import ru.vyarus.spock.jupiter.engine.context.ClassContext;
import ru.vyarus.spock.jupiter.engine.context.MethodContext;

public class JunitApiExecutor {
    private final Logger logger = LoggerFactory.getLogger(JunitApiExecutor.class);

    public void beforeAll(ClassContext context) {
        for (BeforeAllCallback callback : this.getExtensions(context, BeforeAllCallback.class)) {
            context.getCollector().execute(() -> callback.beforeAll((ExtensionContext)context));
            if (!context.getCollector().isNotEmpty()) continue;
            break;
        }
        context.getCollector().assertEmpty();
    }

    public void instancePostProcessors(ClassContext context, Object instance) {
        context.getCollector().execute(() -> this.getExtensions(context, TestInstancePostProcessor.class).forEach(extension -> this.executeAndMaskThrowable(() -> extension.postProcessTestInstance(instance, (ExtensionContext)context))));
        context.getCollector().assertEmpty();
    }

    public void beforeEach(MethodContext context) {
        ThrowableCollector collector = context.getCollector();
        for (BeforeEachCallback callback : this.getExtensions(context, BeforeEachCallback.class)) {
            collector.execute(() -> callback.beforeEach((ExtensionContext)context));
            if (!collector.isNotEmpty()) continue;
            break;
        }
        collector.assertEmpty();
    }

    public void beforeTestExecution(MethodContext context) {
        ThrowableCollector collector = context.getCollector();
        for (BeforeTestExecutionCallback callback : this.getExtensions(context, BeforeTestExecutionCallback.class)) {
            collector.execute(() -> callback.beforeTestExecution((ExtensionContext)context));
            if (!collector.isNotEmpty()) continue;
            break;
        }
        collector.assertEmpty();
    }

    public void afterTestExecution(MethodContext context) {
        ThrowableCollector collector = context.getCollector();
        this.getReversedExtensions(context, AfterTestExecutionCallback.class).forEach(callback -> collector.execute(() -> callback.afterTestExecution((ExtensionContext)context)));
        collector.assertEmpty();
    }

    public void afterEach(MethodContext context) {
        ThrowableCollector collector = context.getCollector();
        this.getReversedExtensions(context, AfterEachCallback.class).forEach(callback -> collector.execute(() -> callback.afterEach((ExtensionContext)context)));
        collector.assertEmpty();
    }

    public void instancePreDestroy(MethodContext context) {
        ThrowableCollector collector = context.getCollector();
        this.getReversedExtensions(context, TestInstancePreDestroyCallback.class).forEach(callback -> collector.execute(() -> callback.preDestroyTestInstance((ExtensionContext)context)));
        collector.assertEmpty();
    }

    public void afterAll(ClassContext context) {
        ThrowableCollector collector = context.getCollector();
        this.getReversedExtensions(context, AfterAllCallback.class).forEach(extension -> collector.execute(() -> extension.afterAll((ExtensionContext)context)));
        collector.assertEmpty();
    }

    public void handleTestException(MethodContext context, Throwable error) {
        this.processTestException(context, this.getReversedExtensions(context, TestExecutionExceptionHandler.class), error);
    }

    private <T extends Extension> List<T> getReversedExtensions(AbstractContext context, Class<T> type) {
        return this.getExtensions(context, type, true);
    }

    private <T extends Extension> List<T> getExtensions(AbstractContext context, Class<T> type) {
        return this.getExtensions(context, type, false);
    }

    private <T extends Extension> List<T> getExtensions(AbstractContext context, Class<T> type, boolean reversed) {
        List exts;
        List list = exts = reversed ? context.getRegistry().getReversedExtensions(type) : context.getRegistry().getExtensions(type);
        if (!exts.isEmpty()) {
            this.logger.debug(() -> "Junit " + ((Class)context.getSpec().getReflection()).getSimpleName() + "." + type.getSimpleName() + ": " + exts.stream().map(t -> t.getClass().getSimpleName()).collect(Collectors.joining(", ")));
        }
        return exts;
    }

    private void executeAndMaskThrowable(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable throwable) {
            ExceptionUtils.throwAsUncheckedException((Throwable)throwable);
        }
    }

    private void processTestException(MethodContext context, List<TestExecutionExceptionHandler> handlers, Throwable error) {
        if (handlers.isEmpty()) {
            ExceptionUtils.throwAsUncheckedException((Throwable)error);
        }
        try {
            handlers.remove(0).handleTestExecutionException((ExtensionContext)context, error);
        }
        catch (Throwable handledThrowable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)handledThrowable);
            this.processTestException(context, handlers, handledThrowable);
        }
    }
}

