/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.spock.jupiter.engine.context;

import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;
import ru.vyarus.spock.jupiter.engine.ExtensionRegistry;
import ru.vyarus.spock.jupiter.engine.context.DefaultExecutableInvoker;
import ru.vyarus.spock.jupiter.engine.store.ExtensionValuesStore;
import ru.vyarus.spock.jupiter.engine.store.NamespaceAwareStore;

public abstract class AbstractContext
implements ExtensionContext,
AutoCloseable {
    protected final ExtensionContext parent;
    protected final ExtensionRegistry registry;
    protected final AnnotatedElement element;
    protected final SpecInfo spec;
    protected final ThrowableCollector collector;
    private final ExtensionValuesStore valuesStore;
    private final ExecutableInvoker invoker;

    public AbstractContext(ExtensionContext parent, ExtensionRegistry registry, AnnotatedElement element, SpecInfo spec) {
        this.parent = parent;
        this.registry = registry;
        this.element = element;
        this.spec = spec;
        this.collector = new OpenTest4JAwareThrowableCollector();
        this.valuesStore = this.createStore(parent);
        this.invoker = new DefaultExecutableInvoker(this);
    }

    public Optional<ExtensionContext> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public ExtensionContext getRoot() {
        return this.parent != null ? this.parent.getRoot() : this;
    }

    public Set<String> getTags() {
        return Collections.emptySet();
    }

    public Optional<AnnotatedElement> getElement() {
        return Optional.ofNullable(this.element);
    }

    public Optional<Class<?>> getTestClass() {
        return Optional.ofNullable(this.spec).map(NodeInfo::getReflection);
    }

    public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
        return Optional.of(TestInstance.Lifecycle.PER_METHOD);
    }

    public Optional<Throwable> getExecutionException() {
        return Optional.ofNullable(this.collector.getThrowable());
    }

    public Optional<String> getConfigurationParameter(String key) {
        return Optional.empty();
    }

    public <T> Optional<T> getConfigurationParameter(String key, Function<String, T> transformer) {
        return Optional.empty();
    }

    public void publishReportEntry(Map<String, String> map) {
    }

    public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
        Preconditions.notNull((Object)namespace, (String)"Namespace must not be null");
        return new NamespaceAwareStore(this.valuesStore, namespace);
    }

    public ExecutionMode getExecutionMode() {
        org.spockframework.runtime.model.parallel.ExecutionMode executionMode = Optional.ofNullable(this.spec).map(info -> info.getExecutionMode().orElse(org.spockframework.runtime.model.parallel.ExecutionMode.SAME_THREAD)).orElse(org.spockframework.runtime.model.parallel.ExecutionMode.SAME_THREAD);
        return ExecutionMode.valueOf((String)executionMode.name());
    }

    public ExecutableInvoker getExecutableInvoker() {
        return this.invoker;
    }

    public ExtensionRegistry getRegistry() {
        return this.registry;
    }

    public SpecInfo getSpec() {
        return this.spec;
    }

    public ThrowableCollector getCollector() {
        return this.collector;
    }

    @Override
    public void close() {
        this.valuesStore.closeAllStoredCloseableValues();
    }

    private ExtensionValuesStore createStore(ExtensionContext parent) {
        ExtensionValuesStore parentStore = null;
        if (parent != null) {
            parentStore = ((AbstractContext)parent).valuesStore;
        }
        return new ExtensionValuesStore(parentStore);
    }
}

