/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.core.ByteBuffer;
import ru.yandex.clickhouse.jdbcbridge.core.ColumnDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.DataAccessException;
import ru.yandex.clickhouse.jdbcbridge.core.DataTableReader;
import ru.yandex.clickhouse.jdbcbridge.core.DataType;
import ru.yandex.clickhouse.jdbcbridge.core.DefaultValues;
import ru.yandex.clickhouse.jdbcbridge.core.Extension;
import ru.yandex.clickhouse.jdbcbridge.core.ExtensionManager;
import ru.yandex.clickhouse.jdbcbridge.core.NamedDataSource;
import ru.yandex.clickhouse.jdbcbridge.core.QueryParameters;
import ru.yandex.clickhouse.jdbcbridge.core.Repository;
import ru.yandex.clickhouse.jdbcbridge.core.ResponseWriter;
import ru.yandex.clickhouse.jdbcbridge.core.TableDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;

public class JdbcDataSource
extends NamedDataSource {
    private static final Logger log = LoggerFactory.getLogger(JdbcDataSource.class);
    private static final Set<String> PRIVATE_PROPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$schema", "type", "timezone", "cache", "aliases", "driverUrls", "queryTimeout", "writeTimeout", "sealed")));
    private static final Properties DEFAULT_DATASOURCE_PROPERTIES = new Properties();
    private static final String PROP_DRIVER_CLASS = "driverClassName";
    private static final String PROP_POOL_NAME = "poolName";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_CLIENT_NAME = "ClientUser";
    private static final String DEFAULT_CLIENT_NAME = "clickhouse-jdbc-bridge";
    private static final String QUERY_STMT_SELECT = "SELECT ";
    private static final String QUERY_STMT_FROM = " FROM ";
    private static final String QUERY_TABLE_BEGIN = "SELECT * FROM ";
    private static final String QUERY_TABLE_END = " WHERE 1 = 0";
    private static final String CONF_DATASOURCE = "dataSource";
    private static final String QUERY_FILE_EXT = ".sql";
    private static final String USAGE_PREFIX = "hikaricp.";
    private static final String USAGE_POOL = "pool";
    public static final String EXTENSION_NAME = "jdbc";
    private final String jdbcUrl;
    private final HikariDataSource datasource;
    private String quoteIdentifier = null;

    protected static void deregisterJdbcDriver(String driverClassName) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!driver.getClass().getName().equals(driverClassName)) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                log.error("Failed to deregister driver: " + driver, (Throwable)e);
            }
        }
    }

    public static void initialize(ExtensionManager manager) {
        Extension<JdbcDataSource> thisExtension = manager.getExtension(JdbcDataSource.class);
        manager.getRepositoryManager().getRepository(NamedDataSource.class).registerType(EXTENSION_NAME, thisExtension);
    }

    public static JdbcDataSource newInstance(Object ... args) {
        if (Objects.requireNonNull(args).length < 2) {
            throw new IllegalArgumentException("In order to create JDBC datasource, you need to specify at least ID and datasource manager.");
        }
        String id = (String)args[0];
        Repository manager = (Repository)Objects.requireNonNull(args[1]);
        JsonObject config = args.length > 2 ? (JsonObject)args[2] : null;
        JdbcDataSource ds = new JdbcDataSource(id, manager, config);
        ds.validate();
        return ds;
    }

    private int bulkMutation(PreparedStatement stmt) throws SQLException {
        int mutationCount = 0;
        int[] results = stmt.executeBatch();
        for (int i = 0; i < results.length; ++i) {
            mutationCount += results[i];
        }
        stmt.clearBatch();
        return mutationCount;
    }

    private String buildErrorMessage(Throwable t) {
        Throwable rootCause;
        StringBuilder err = new StringBuilder();
        if (t instanceof SQLException) {
            SQLException exp = (SQLException)t;
            String state = exp.getSQLState();
            int code = exp.getErrorCode();
            if (state != null && state.length() > 0) {
                err.append("SQLState(").append(state).append(')').append(' ');
            }
            err.append("VendorCode(").append(code).append(')').append(' ').append(exp.getMessage());
        } else {
            err.append(t == null ? "Unknown error: " : t.getMessage());
        }
        for (rootCause = t; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        if (rootCause != t) {
            err.append('\n').append("Root cause: ").append(rootCause.getMessage());
        }
        return err.toString();
    }

    protected Driver findDriver(String url) {
        ServiceLoader<Driver> loader = ServiceLoader.load(Driver.class, this.getDriverClassLoader());
        for (Driver d : loader) {
            try {
                if (!d.acceptsURL(url)) continue;
                return d;
            }
            catch (SQLException e) {
                log.warn("Error occured when testing driver [{}] due to [{}]", (Object)d, (Object)e.getMessage());
            }
        }
        throw new IllegalStateException("Not able to find suitable driver for datasource: " + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcDataSource(String id, Repository<NamedDataSource> resolver, JsonObject config) {
        super(id, resolver, config);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)DEFAULT_DATASOURCE_PROPERTIES);
        if (id != null && id.startsWith(EXTENSION_NAME) && config == null) {
            this.jdbcUrl = id;
            this.datasource = null;
        } else {
            if (config != null) {
                for (Map.Entry field : config) {
                    String key = (String)field.getKey();
                    if (PRIVATE_PROPS.contains(key)) continue;
                    Object value = field.getValue();
                    if (value instanceof JsonObject) {
                        if (!CONF_DATASOURCE.equals(key)) continue;
                        for (Map.Entry entry : (JsonObject)value) {
                            String propName = (String)entry.getKey();
                            String propValue = String.valueOf(entry.getValue());
                            if (!PROP_PASSWORD.equals(propName)) {
                                propValue = resolver.resolve(propValue);
                            }
                            props.setProperty(key + '.' + propName, propValue);
                        }
                        continue;
                    }
                    if (value == null || value instanceof JsonArray) continue;
                    String propValue = String.valueOf(value);
                    if (!PROP_PASSWORD.equals(key)) {
                        propValue = resolver.resolve(propValue);
                    }
                    props.setProperty(key, propValue);
                }
            }
            props.setProperty(PROP_POOL_NAME, id);
            this.jdbcUrl = null;
            if (USE_CUSTOM_DRIVER_LOADER) {
                String driverClassName = props.getProperty(PROP_DRIVER_CLASS);
                if (driverClassName == null || driverClassName.isEmpty()) {
                    String url = props.getProperty("jdbcUrl");
                    if (url == null || url.isEmpty()) {
                        throw new IllegalArgumentException("jdbcUrl was not specified!");
                    }
                    driverClassName = this.findDriver(url).getClass().getName();
                    props.setProperty(PROP_DRIVER_CLASS, driverClassName);
                }
                JdbcDataSource.deregisterJdbcDriver(driverClassName);
                Thread currentThread = Thread.currentThread();
                ClassLoader currentContextClassLoader = currentThread.getContextClassLoader();
                try {
                    ClassLoader loader = this.getDriverClassLoader();
                    currentThread.setContextClassLoader(loader);
                    HikariConfig conf = new HikariConfig(props);
                    conf.setMetricRegistry(Utils.getDefaultMetricRegistry());
                    this.datasource = new HikariDataSource(conf);
                }
                finally {
                    currentThread.setContextClassLoader(currentContextClassLoader);
                }
            } else {
                HikariConfig conf = new HikariConfig(props);
                conf.setMetricRegistry(Utils.getDefaultMetricRegistry());
                this.datasource = new HikariDataSource(conf);
            }
        }
    }

    protected final Connection getConnection() throws SQLException {
        Connection conn;
        if (this.datasource != null) {
            conn = this.datasource.getConnection();
        } else {
            conn = this.findDriver(this.jdbcUrl).connect(this.jdbcUrl, new Properties());
            this.initQuoteIdentifier(conn);
            try {
                conn.setAutoCommit(true);
            }
            catch (Exception e) {
                log.warn("Failed to enable auto-commit due to {}", (Object)e.getMessage());
            }
        }
        try {
            conn.setClientInfo(PROP_CLIENT_NAME, DEFAULT_CLIENT_NAME);
        }
        catch (Exception e) {
            log.warn("Failed call setClientInfo due to {}", (Object)e.getMessage());
        }
        return conn;
    }

    protected final Statement createStatement(Connection conn) throws SQLException {
        return this.createStatement(conn, null);
    }

    protected final Statement createStatement(Connection conn, QueryParameters parameters) throws SQLException {
        Statement stmt;
        if (parameters == null) {
            stmt = conn.createStatement();
        } else {
            boolean scrollable = parameters.getPosition() != 0;
            stmt = conn.createStatement(scrollable ? 1004 : 1003, 1007);
            stmt.setFetchSize(parameters.getFetchSize());
            stmt.setMaxRows(parameters.getMaxRows());
        }
        return stmt;
    }

    protected final PreparedStatement createPreparedStatement(Connection conn, String sql, QueryParameters parameters) throws SQLException {
        log.info("Mutation: {}", (Object)sql);
        return conn.prepareStatement(sql);
    }

    protected final void setTimeout(Statement stmt, int expectedTimeout) {
        int currentTimeout = 0;
        try {
            currentTimeout = stmt.getQueryTimeout();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currentTimeout != expectedTimeout && expectedTimeout >= 0) {
            try {
                stmt.setQueryTimeout(expectedTimeout);
            }
            catch (Exception e) {
                log.warn("Not able to set query timeout to {} seconds", (Object)expectedTimeout);
            }
        }
    }

    protected long getFirstMutationResult(Statement stmt) throws SQLException {
        long count = 0L;
        try {
            count = stmt.getLargeUpdateCount();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            count = stmt.getUpdateCount();
        }
        return count == -1L ? 0L : count;
    }

    protected ResultSet getFirstQueryResult(Statement stmt, boolean hasResultSet) throws SQLException {
        ResultSet rs = null;
        if (hasResultSet) {
            rs = stmt.getResultSet();
        } else if (stmt.getUpdateCount() == -1) {
            throw new SQLException("No query result!");
        }
        return rs != null ? rs : this.getFirstQueryResult(stmt, stmt.getMoreResults());
    }

    protected String getColumnName(ResultSetMetaData meta, int columnIndex) throws SQLException {
        String columnName;
        block4: {
            columnName = null;
            boolean fallback = true;
            try {
                columnName = meta.getColumnLabel(columnIndex);
                if (columnName == null || columnName.isEmpty()) {
                    fallback = false;
                    columnName = meta.getColumnName(columnIndex);
                }
            }
            catch (RuntimeException e) {
                if (!fallback) break block4;
                columnName = meta.getColumnName(columnIndex);
            }
        }
        if (columnName == null || columnName.isEmpty()) {
            columnName = JdbcDataSource.generateColumnName(columnIndex);
        }
        return columnName;
    }

    protected ColumnDefinition[] getColumnsFromResultSet(ResultSet rs, QueryParameters params) throws SQLException {
        ResultSetMetaData meta = Objects.requireNonNull(rs).getMetaData();
        ColumnDefinition[] columns = new ColumnDefinition[meta.getColumnCount()];
        for (int i = 1; i <= columns.length; ++i) {
            boolean isSigned = true;
            int nullability = 1;
            int length = 0;
            int precision = 0;
            int scale = 0;
            try {
                isSigned = meta.isSigned(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                nullability = meta.isNullable(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                length = meta.getColumnDisplaySize(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                precision = meta.getPrecision(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                scale = meta.getScale(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String name = this.getColumnName(meta, i);
            String typeName = meta.getColumnTypeName(i);
            JDBCType jdbcType = JDBCType.valueOf(meta.getColumnType(i));
            DataType type = this.converter.from(jdbcType, typeName, precision, scale, isSigned);
            columns[i - 1] = new ColumnDefinition(name, type, 0 != nullability, length, precision, scale);
        }
        return columns;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected TableDefinition inferTypes(String schema, String originalQuery, String loadedQuery, QueryParameters params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected boolean isSavedQuery(String file) {
        return super.isSavedQuery(file) || file.endsWith(QUERY_FILE_EXT);
    }

    @Override
    protected void writeMutationResult(String schema, String originalQuery, String loadedQuery, QueryParameters params, ColumnDefinition[] requestColumns, ColumnDefinition[] customColumns, DefaultValues defaultValues, ResponseWriter writer) {
        try (Connection conn = this.getConnection();
             Statement stmt = this.createStatement(conn, params);){
            this.setTimeout(stmt, this.getQueryTimeout(params.getTimeout()));
            stmt.execute(loadedQuery);
            this.writeMutationResult(this.getFirstMutationResult(stmt), requestColumns, customColumns, writer);
        }
        catch (SQLException e) {
            throw new DataAccessException(this.getId(), this.buildErrorMessage(e), e);
        }
        catch (DataAccessException e) {
            Throwable cause = e.getCause();
            throw new IllegalStateException("Failed to mutate against [" + this.getId() + "] due to: " + this.buildErrorMessage(cause), cause);
        }
    }

    @Override
    protected void writeQueryResult(String schema, String originalQuery, String loadedQuery, QueryParameters params, ColumnDefinition[] requestColumns, ColumnDefinition[] customColumns, DefaultValues defaultValues, ResponseWriter writer) {
        Serializable sb;
        if (!Utils.containsWhitespace(loadedQuery)) {
            String quote = this.getQuoteIdentifier();
            sb = new StringBuilder();
            ((StringBuilder)sb).append(QUERY_STMT_SELECT);
            if (requestColumns == null || requestColumns.length == 0) {
                ((StringBuilder)sb).append('*');
            } else {
                for (ColumnDefinition c : requestColumns) {
                    ((StringBuilder)sb).append(quote).append(c.getName()).append(quote).append(',');
                }
                ((StringBuilder)sb).deleteCharAt(((StringBuilder)sb).length() - 1);
            }
            ((StringBuilder)sb).append(QUERY_STMT_FROM);
            if (schema != null && !schema.isEmpty() && !Utils.containsWhitespace(schema)) {
                ((StringBuilder)sb).append(quote).append(schema).append(quote).append('.');
            }
            ((StringBuilder)sb).append(quote).append(loadedQuery).append(quote);
            loadedQuery = ((StringBuilder)sb).toString();
        }
        try {
            Connection conn = this.getConnection();
            sb = null;
            try (Statement stmt = this.createStatement(conn, params);){
                this.setTimeout(stmt, this.getQueryTimeout(params.getTimeout()));
                ResultSet rs = this.getFirstQueryResult(stmt, stmt.execute(loadedQuery));
                ResultSetReader reader = new ResultSetReader(this.getId(), rs, params);
                reader.process(this.getId(), requestColumns, customColumns, this.getColumnsFromResultSet(rs, params), defaultValues, this.getTimeZone(), params, writer);
            }
            catch (Throwable throwable) {
                sb = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (sb != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)sb).addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new DataAccessException(this.getId(), this.buildErrorMessage(e), e);
        }
        catch (DataAccessException e) {
            Throwable cause = e.getCause();
            throw new IllegalStateException("Failed to query against [" + this.getId() + "] due to: " + this.buildErrorMessage(cause), cause);
        }
    }

    protected final void write(PreparedStatement stmt, ColumnDefinition[] cols, QueryParameters params, ByteBuffer buffer) throws SQLException {
        block21: for (int i = 1; i <= cols.length; ++i) {
            ColumnDefinition info = cols[i - 1];
            if (info.isNullable() && buffer.readNull()) {
                stmt.setString(i, null);
                continue;
            }
            switch (info.getType()) {
                case Bool: 
                case Int8: {
                    stmt.setByte(i, buffer.readInt8());
                    continue block21;
                }
                case Int16: {
                    stmt.setShort(i, buffer.readInt16());
                    continue block21;
                }
                case Int32: {
                    stmt.setInt(i, buffer.readInt32());
                    continue block21;
                }
                case Int64: {
                    stmt.setLong(i, buffer.readInt64());
                    continue block21;
                }
                case UInt8: {
                    stmt.setInt(i, buffer.readUInt8());
                    continue block21;
                }
                case UInt16: {
                    stmt.setInt(i, buffer.readUInt8());
                    continue block21;
                }
                case UInt32: {
                    stmt.setLong(i, buffer.readUInt32());
                    continue block21;
                }
                case UInt64: {
                    stmt.setString(i, buffer.readUInt64().toString(10));
                    continue block21;
                }
                case Float32: {
                    stmt.setFloat(i, buffer.readFloat32());
                    continue block21;
                }
                case Float64: {
                    stmt.setDouble(i, buffer.readFloat64());
                    continue block21;
                }
                case Date: {
                    stmt.setDate(i, buffer.readDate());
                    continue block21;
                }
                case DateTime: {
                    stmt.setTimestamp(i, buffer.readDateTime(info.getTimeZone()));
                    continue block21;
                }
                case DateTime64: {
                    stmt.setTimestamp(i, buffer.readDateTime64(info.getTimeZone()));
                    continue block21;
                }
                case Decimal: {
                    stmt.setBigDecimal(i, buffer.readDecimal(info.getPrecision(), info.getScale()));
                    continue block21;
                }
                case Decimal32: {
                    stmt.setBigDecimal(i, buffer.readDecimal32(info.getScale()));
                    continue block21;
                }
                case Decimal64: {
                    stmt.setBigDecimal(i, buffer.readDecimal64(info.getScale()));
                    continue block21;
                }
                case Decimal128: {
                    stmt.setBigDecimal(i, buffer.readDecimal128(info.getScale()));
                    continue block21;
                }
                case Decimal256: {
                    stmt.setBigDecimal(i, buffer.readDecimal256(info.getScale()));
                    continue block21;
                }
                case Str: {
                    stmt.setString(i, buffer.readString());
                    continue block21;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initQuoteIdentifier(Connection conn) {
        if (this.quoteIdentifier == null) {
            JdbcDataSource jdbcDataSource = this;
            synchronized (jdbcDataSource) {
                if (this.quoteIdentifier == null) {
                    this.quoteIdentifier = "`";
                    String errorMsg = "Failed to get identifier quote string due to {}";
                    String str = null;
                    if (conn != null) {
                        try {
                            str = conn.getMetaData().getIdentifierQuoteString();
                        }
                        catch (Exception e) {
                            log.warn(errorMsg, (Object)e.getMessage());
                        }
                    } else {
                        try (Connection c = this.getConnection();){
                            str = c.getMetaData().getIdentifierQuoteString();
                        }
                        catch (Exception e) {
                            log.warn(errorMsg, (Object)e.getMessage());
                        }
                    }
                    if (str != null && !str.trim().isEmpty()) {
                        this.quoteIdentifier = str;
                    }
                }
            }
        }
    }

    @Override
    public final String getType() {
        return EXTENSION_NAME;
    }

    @Override
    public final String getQuoteIdentifier() {
        this.initQuoteIdentifier(null);
        return this.quoteIdentifier;
    }

    @Override
    public String getPoolUsage() {
        JsonObject obj = new JsonObject();
        Object metricRegistry = Utils.getDefaultMetricRegistry();
        if (metricRegistry instanceof MeterRegistry) {
            for (Meter meter : ((MeterRegistry)metricRegistry).getMeters()) {
                Meter.Id meterId = meter.getId();
                String name = meterId.getName();
                if (name == null || !name.startsWith(USAGE_PREFIX) || !this.getId().equals(meterId.getTag(USAGE_POOL))) continue;
                name = name.substring(USAGE_PREFIX.length()).replace('.', '_');
                for (Measurement m : meter.measure()) {
                    obj.put(name + "_" + m.getStatistic().getTagValueRepresentation(), Double.valueOf(m.getValue()));
                }
            }
        }
        return obj.toString();
    }

    @Override
    public void executeMutation(String schema, String table, TableDefinition columns, QueryParameters params, ByteBuffer buffer, ResponseWriter writer) {
        log.info("Executing mutation: schema=[{}], table=[{}]", (Object)schema, (Object)table);
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        if (schema != null && schema.length() > 0 && table.indexOf(46) == -1) {
            sql.append(schema).append('.');
        }
        sql.append(table).append(" VALUES(?");
        ColumnDefinition[] cols = columns.getColumns();
        for (int i = 1; i < cols.length; ++i) {
            sql.append(',').append('?');
        }
        sql.append(')');
        int batchSize = params.getBatchSize();
        int rowCount = 0;
        int mutationCount = 0;
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = this.createPreparedStatement(conn, sql.toString(), params);){
            this.setTimeout(stmt, this.getWriteTimeout(params.getTimeout()));
            int counter = 0;
            boolean stopped = false;
            while (!buffer.isExausted()) {
                this.write(stmt, cols, params, buffer);
                ++rowCount;
                if (batchSize <= 0) {
                    mutationCount += stmt.executeUpdate();
                } else {
                    stmt.addBatch();
                    if (++counter >= batchSize) {
                        mutationCount += this.bulkMutation(stmt);
                        counter = 0;
                    }
                }
                if (writer.isOpen()) continue;
                stopped = true;
                break;
            }
            if (!stopped && batchSize > 0 && counter > 0) {
                mutationCount += this.bulkMutation(stmt);
            }
            log.info("Mutation {} on [{}]: batchSize={}, inputRows={}, effectedRows={}", new Object[]{stopped ? "stopped" : "completed", this.getId(), batchSize, rowCount, mutationCount});
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to mutate in [" + this.getId() + "] due to: " + this.buildErrorMessage(e), e);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    static {
        DEFAULT_DATASOURCE_PROPERTIES.setProperty("connectionTestQuery", "SELECT 1");
        DEFAULT_DATASOURCE_PROPERTIES.setProperty("minimumIdle", "1");
        DEFAULT_DATASOURCE_PROPERTIES.setProperty("maximumPoolSize", "5");
    }

    static class ResultSetReader
    implements DataTableReader {
        private final String id;
        private final ResultSet rs;
        private final QueryParameters params;

        protected ResultSetReader(String id, ResultSet rs, QueryParameters params) {
            this.id = id;
            this.rs = rs;
            this.params = params;
        }

        @Override
        public int skipRows(QueryParameters parameters) {
            int rowCount = 0;
            if (this.rs == null || parameters == null) {
                return rowCount;
            }
            int position = parameters.getPosition();
            int offset = parameters.getOffset();
            if (position != 0 || (position = offset) < 0) {
                try {
                    this.rs.absolute(position);
                    rowCount = position;
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Not able to move cursor to row #" + position, e);
                }
            } else if (offset != 0) {
                DataTableReader.super.skipRows(parameters);
            }
            return rowCount;
        }

        @Override
        public boolean nextRow() {
            try {
                return this.rs.next();
            }
            catch (SQLException e) {
                throw new DataAccessException(this.id, e);
            }
        }

        @Override
        public boolean isNull(int row, int column, ColumnDefinition metadata) {
            ++column;
            try {
                return this.rs.getObject(column) == null || this.rs.wasNull();
            }
            catch (SQLException e) {
                throw new DataAccessException(this.id, e);
            }
        }

        @Override
        public void read(int row, int column, ColumnDefinition metadata, ByteBuffer buffer) {
            ++column;
            try {
                Object value = null;
                switch (metadata.getType()) {
                    case Bool: 
                    case Enum: 
                    case Enum8: {
                        value = this.rs.getObject(column);
                        if (value instanceof Integer) {
                            int optionValue = (Integer)value;
                            buffer.writeEnum8(metadata.requireValidOptionValue(optionValue));
                            break;
                        }
                        buffer.writeEnum8(metadata.getOptionValue(String.valueOf(value)));
                        break;
                    }
                    case Enum16: {
                        value = this.rs.getObject(column);
                        if (value instanceof Integer) {
                            int optionValue = (Integer)value;
                            buffer.writeEnum16(metadata.requireValidOptionValue(optionValue));
                            break;
                        }
                        buffer.writeEnum16(metadata.getOptionValue(String.valueOf(value)));
                        break;
                    }
                    case Int8: {
                        buffer.writeInt8(this.rs.getInt(column));
                        break;
                    }
                    case Int16: {
                        buffer.writeInt16(this.rs.getInt(column));
                        break;
                    }
                    case Int32: {
                        buffer.writeInt32(this.rs.getInt(column));
                        break;
                    }
                    case Int64: {
                        buffer.writeInt64(this.rs.getLong(column));
                        break;
                    }
                    case Int128: {
                        buffer.writeInt128(this.rs.getObject(column, BigInteger.class));
                        break;
                    }
                    case Int256: {
                        buffer.writeInt256(this.rs.getObject(column, BigInteger.class));
                        break;
                    }
                    case UInt8: {
                        buffer.writeUInt8(this.rs.getInt(column));
                        break;
                    }
                    case UInt16: {
                        buffer.writeUInt16(this.rs.getInt(column));
                        break;
                    }
                    case UInt32: {
                        buffer.writeUInt32(this.rs.getLong(column));
                        break;
                    }
                    case UInt64: {
                        buffer.writeUInt64(this.rs.getLong(column));
                        break;
                    }
                    case UInt128: {
                        buffer.writeUInt128(this.rs.getObject(column, BigInteger.class));
                        break;
                    }
                    case UInt256: {
                        buffer.writeUInt256(this.rs.getObject(column, BigInteger.class));
                        break;
                    }
                    case Float32: {
                        buffer.writeFloat32(this.rs.getFloat(column));
                        break;
                    }
                    case Float64: {
                        buffer.writeFloat64(this.rs.getDouble(column));
                        break;
                    }
                    case Date: {
                        buffer.writeDate(this.rs.getDate(column));
                        break;
                    }
                    case DateTime: {
                        buffer.writeDateTime(this.rs.getTimestamp(column), metadata.getTimeZone());
                        break;
                    }
                    case DateTime64: {
                        buffer.writeDateTime64(this.rs.getTimestamp(column), metadata.getScale(), metadata.getTimeZone());
                        break;
                    }
                    case Decimal: {
                        buffer.writeDecimal(this.rs.getBigDecimal(column), metadata.getPrecision(), metadata.getScale());
                        break;
                    }
                    case Decimal32: {
                        buffer.writeDecimal32(this.rs.getBigDecimal(column), metadata.getScale());
                        break;
                    }
                    case Decimal64: {
                        buffer.writeDecimal64(this.rs.getBigDecimal(column), metadata.getScale());
                        break;
                    }
                    case Decimal128: {
                        buffer.writeDecimal128(this.rs.getBigDecimal(column), metadata.getScale());
                        break;
                    }
                    case Decimal256: {
                        buffer.writeDecimal256(this.rs.getBigDecimal(column), metadata.getScale());
                        break;
                    }
                    case FixedStr: {
                        buffer.writeFixedString(this.rs.getString(column), metadata.getLength());
                        break;
                    }
                    default: {
                        buffer.writeString(this.rs.getString(column), this.params.nullAsDefault());
                        break;
                    }
                }
            }
            catch (SQLException e) {
                throw new DataAccessException(this.id, e);
            }
        }
    }
}

