/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import java.util.Date;
import java.util.Objects;
import ru.yandex.clickhouse.jdbcbridge.core.NamedDataSource;
import ru.yandex.clickhouse.jdbcbridge.core.UsageStats;

public class DataSourceStats
implements UsageStats {
    private final String idOrAlias;
    private final int instance;
    private final boolean alias;
    private final Date createDateTime;
    private final String type;
    private final String defaults;
    private final String parameters;
    private final String customColumns;
    private final String cacheUsage;
    private final String poolUsage;

    public DataSourceStats(String id, NamedDataSource ds) {
        this.idOrAlias = Objects.requireNonNull(id);
        this.instance = ds.hashCode();
        this.alias = !this.idOrAlias.equals(Objects.requireNonNull(ds).getId());
        this.createDateTime = ds.getCreateDateTime();
        this.type = ds.getType();
        this.defaults = ds.getDefaultValuesAsJsonString();
        this.parameters = ds.getParametersAsJsonString();
        this.customColumns = ds.getCustomColumnsAsJsonString();
        this.cacheUsage = ds.getCacheUsage();
        this.poolUsage = ds.getPoolUsage();
    }

    @Override
    public String getName() {
        return this.idOrAlias;
    }

    public int getInstance() {
        return this.instance;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public String getType() {
        return this.type;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getCustomColumns() {
        return this.customColumns;
    }

    public String getDefaults() {
        return this.defaults;
    }

    public String getCacheUsage() {
        return this.cacheUsage;
    }

    public String getPoolUsage() {
        return this.poolUsage;
    }
}

