/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.except;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.except.ClickHouseErrorCode;
import ru.yandex.clickhouse.except.ClickHouseException;
import ru.yandex.clickhouse.except.ClickHouseUnknownException;
import ru.yandex.clickhouse.util.apache.StringUtils;

public final class ClickHouseExceptionSpecifier {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseExceptionSpecifier.class);

    private ClickHouseExceptionSpecifier() {
    }

    public static ClickHouseException specify(Throwable cause, String host, int port) {
        return ClickHouseExceptionSpecifier.specify(cause != null ? cause.getMessage() : null, cause, host, port);
    }

    public static ClickHouseException specify(String clickHouseMessage, String host, int port) {
        return ClickHouseExceptionSpecifier.specify(clickHouseMessage, null, host, port);
    }

    private static ClickHouseException specify(String clickHouseMessage, Throwable cause, String host, int port) {
        if (StringUtils.isEmpty(clickHouseMessage) && cause != null) {
            return ClickHouseExceptionSpecifier.getException(cause, host, port);
        }
        try {
            Throwable messageHolder;
            int code = clickHouseMessage.startsWith("Poco::Exception. Code: 1000, ") ? 1000 : ClickHouseExceptionSpecifier.getErrorCode(clickHouseMessage);
            Throwable throwable = messageHolder = cause != null ? cause : new Throwable(clickHouseMessage);
            if (code == -1) {
                return ClickHouseExceptionSpecifier.getException(messageHolder, host, port);
            }
            return new ClickHouseException(code, messageHolder, host, port);
        }
        catch (Exception e) {
            log.error("Unsupported ClickHouse error format, please fix ClickHouseExceptionSpecifier, message: " + clickHouseMessage + ", error: " + e.getMessage());
            return new ClickHouseUnknownException(clickHouseMessage, cause, host, port);
        }
    }

    private static int getErrorCode(String errorMessage) {
        int endIndex;
        int startIndex = errorMessage.indexOf(32);
        int n = endIndex = startIndex == -1 ? -1 : errorMessage.indexOf(startIndex, 44);
        if (startIndex == -1 || endIndex == -1) {
            return -1;
        }
        return Integer.parseInt(errorMessage.substring(startIndex + 1, endIndex));
    }

    private static ClickHouseException getException(Throwable cause, String host, int port) {
        if (cause instanceof SocketTimeoutException) {
            return new ClickHouseException(ClickHouseErrorCode.TIMEOUT_EXCEEDED.code, cause, host, port);
        }
        if (cause instanceof ConnectTimeoutException || cause instanceof ConnectException) {
            return new ClickHouseException(ClickHouseErrorCode.NETWORK_ERROR.code, cause, host, port);
        }
        return new ClickHouseUnknownException(cause, host, port);
    }

    private static interface ClickHouseExceptionFactory {
        public ClickHouseException create(Integer var1, Throwable var2, String var3, int var4);
    }
}

