/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.settings;

import java.sql.DriverPropertyInfo;
import java.util.Properties;
import ru.yandex.clickhouse.settings.DriverPropertyCreator;

public enum ClickHouseQueryParam implements DriverPropertyCreator
{
    MAX_PARALLEL_REPLICAS("max_parallel_replicas", null, Integer.class, "max shard replica count "),
    TOTALS_MODE("totals_mode", null, String.class, "How to calculate TOTALS when HAVING is present, as well as when max_rows_to_group_by and group_by_overflow_mode = 'any' are present."),
    QUOTA_KEY("quota_key", null, String.class, "quota is calculated for each quota_key value. For example here may be some user name."),
    PRIORITY("priority", null, Integer.class, "The lower the value the bigger the priority."),
    DATABASE("database", null, String.class, "database name used by default"),
    COMPRESS("compress", true, Boolean.class, "whether to compress transferred data or not"),
    EXTREMES("extremes", false, Boolean.class, "Whether to include extreme values."),
    MAX_THREADS("max_threads", null, Integer.class, "The maximum number of query processing threads"),
    MAX_EXECUTION_TIME("max_execution_time", null, Integer.class, "Maximum query execution time in seconds."),
    MAX_BLOCK_SIZE("max_block_size", null, Integer.class, "Recommendation for what size of block (in number of rows) to load from tables"),
    MAX_ROWS_TO_GROUP_BY("max_rows_to_group_by", null, Integer.class, "Maximum number of unique keys received from aggregation. This setting lets you limit memory consumption when aggregating."),
    PROFILE("profile", null, String.class, "Settings profile: a collection of settings grouped under the same name"),
    USER("user", null, String.class, "user name, by default - default"),
    PASSWORD("password", null, String.class, "user password, by default null");

    private final String key;
    private final Object defaultValue;
    private final Class clazz;
    private final String description;

    private ClickHouseQueryParam(String key, Object defaultValue, Class clazz, String description) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.clazz = clazz;
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    @Override
    public DriverPropertyInfo createDriverPropertyInfo(Properties properties) {
        DriverPropertyInfo propertyInfo = new DriverPropertyInfo(this.key, this.driverPropertyValue(properties));
        propertyInfo.required = false;
        propertyInfo.description = this.description;
        propertyInfo.choices = this.driverPropertyInfoChoices();
        return propertyInfo;
    }

    private String[] driverPropertyInfoChoices() {
        String[] stringArray;
        if (this.clazz == Boolean.class || this.clazz == Boolean.TYPE) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "true";
            stringArray = stringArray2;
            stringArray2[1] = "false";
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private String driverPropertyValue(Properties properties) {
        String value = properties.getProperty(this.key);
        if (value == null) {
            value = this.defaultValue == null ? null : this.defaultValue.toString();
        }
        return value;
    }
}

