/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import ru.yandex.clickhouse.response.StreamSplitter;
import ru.yandex.clickhouse.util.guava.StreamUtils;

public class ByteFragment {
    private final byte[] buf;
    private final int start;
    private final int len;
    private static final ByteFragment EMPTY = new ByteFragment(new byte[0], 0, 0);
    private static final byte[] convert = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 92, -1, -1, -1, -1, -1, 8, -1, -1, -1, 12, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, 13, -1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    static final byte[] reverse = new byte[convert.length];

    public ByteFragment(byte[] buf, int start, int len) {
        this.buf = buf;
        this.start = start;
        this.len = len;
    }

    public String asString() {
        return new String(this.buf, this.start, this.len, StreamUtils.UTF_8);
    }

    public String asString(boolean unescape) {
        if (unescape) {
            if (this.isNull()) {
                return null;
            }
            return new String(this.unescape(), StreamUtils.UTF_8);
        }
        return this.asString();
    }

    public boolean isNull() {
        return this.len == 2 && this.buf[this.start] == 92 && this.buf[this.start + 1] == 78;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ByteFragment{[");
        for (byte b1 : this.buf) {
            if (b1 == 9) {
                b.append("<TAB>");
                continue;
            }
            b.append((char)b1);
        }
        b.append(']');
        b.append(", start=" + this.start + ", len=" + this.len + '}');
        return b.toString();
    }

    public ByteFragment[] split(byte sep) {
        StreamSplitter ss = new StreamSplitter(this, sep);
        int c = this.count(sep) + 1;
        ByteFragment[] res = new ByteFragment[c];
        try {
            int i = 0;
            ByteFragment next = null;
            while ((next = ss.next()) != null) {
                res[i++] = next;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (res[c - 1] == null) {
            res[c - 1] = EMPTY;
        }
        return res;
    }

    public ByteArrayInputStream asStream() {
        return new ByteArrayInputStream(this.buf, this.start, this.len);
    }

    private int count(byte sep) {
        int res = 0;
        for (int i = this.start; i < this.start + this.len; ++i) {
            if (this.buf[i] != sep) continue;
            ++res;
        }
        return res;
    }

    public int getLen() {
        return this.len;
    }

    public byte[] unescape() {
        int resLen = 0;
        boolean prevSlash = false;
        for (int i = this.start; i < this.start + this.len; ++i) {
            if (prevSlash) {
                ++resLen;
                prevSlash = false;
                continue;
            }
            if (this.buf[i] == 92) {
                prevSlash = true;
                continue;
            }
            ++resLen;
        }
        if (resLen == this.len) {
            return this.getBytesCopy();
        }
        byte[] res = new byte[resLen];
        int index = 0;
        boolean prevSlash2 = false;
        for (int i = this.start; i < this.start + this.len; ++i) {
            if (prevSlash2) {
                prevSlash2 = false;
                res[index++] = convert[this.buf[i]];
                continue;
            }
            if (this.buf[i] == 92) {
                prevSlash2 = true;
                continue;
            }
            res[index++] = this.buf[i];
        }
        return res;
    }

    public static void escape(byte[] bytes, OutputStream stream) throws IOException {
        for (byte b : bytes) {
            byte converted = reverse[b];
            if (converted != -1) {
                stream.write(92);
                stream.write(converted);
                continue;
            }
            stream.write(b);
        }
    }

    private byte[] getBytesCopy() {
        byte[] bytes = new byte[this.len];
        System.arraycopy(this.buf, this.start, bytes, 0, this.len);
        return bytes;
    }

    public int length() {
        return this.len;
    }

    public int charAt(int i) {
        return this.buf[this.start + i];
    }

    public ByteFragment subseq(int start, int len) {
        if (start < 0 || start + len > this.len) {
            throw new IllegalArgumentException("arg start,len=" + start + "," + len + " while this start,len=" + this.start + "," + this.len);
        }
        return new ByteFragment(this.buf, this.start + start, len);
    }

    static {
        for (int i = 0; i < convert.length; ++i) {
            ByteFragment.reverse[i] = -1;
            byte c = convert[i];
            if (c == -1) continue;
            ByteFragment.reverse[c] = (byte)i;
        }
    }
}

