/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Array;
import java.math.BigInteger;
import ru.yandex.clickhouse.response.ByteFragment;

public final class ByteFragmentUtils {
    public static final char ARRAY_ELEMENTS_SEPARATOR = ',';
    public static final char STRING_QUOTATION = '\'';

    private ByteFragmentUtils() {
    }

    public static int parseInt(ByteFragment s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (s.isNull()) {
            return 0;
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            int limit;
            if (s.charAt(0) == 45) {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / 10;
            if (i < max) {
                if ((digit = s.charAt(i++) - 48) < 0) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = s.charAt(i++) - 48) < 0 || digit > 9) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
        }
        return -result;
    }

    public static long parseLong(ByteFragment s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (s.isNull()) {
            return 0L;
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            long limit;
            if (s.charAt(0) == 45) {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / 10L;
            if (i < max) {
                if ((digit = s.charAt(i++) - 48) < 0 || digit > 9) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = s.charAt(i++) - 48) < 0 || digit > 9) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
        }
        return -result;
    }

    public static Object parseArray(ByteFragment value, Class elementClass) {
        if (value.isNull()) {
            return null;
        }
        if (value.charAt(0) != 91 || value.charAt(value.length() - 1) != 93) {
            throw new IllegalArgumentException("not an array: " + value);
        }
        ByteFragment trim = value.subseq(1, value.length() - 2);
        int index = 0;
        Object array = Array.newInstance(Primitives.unwrap((Class)elementClass), ByteFragmentUtils.getArrayLength(trim));
        int fieldStart = 0;
        boolean inQuotation = false;
        for (int chIdx = 0; chIdx < trim.length(); ++chIdx) {
            int fieldEnd;
            int ch = trim.charAt(chIdx);
            if (ch == 92) {
                ++chIdx;
            }
            if (((inQuotation = ch == 39 ^ inQuotation) || ch != 44) && chIdx != trim.length() - 1) continue;
            int n = fieldEnd = chIdx == trim.length() - 1 ? chIdx + 1 : chIdx;
            if (trim.charAt(fieldStart) == 39) {
                ++fieldStart;
                --fieldEnd;
            }
            ByteFragment fragment = trim.subseq(fieldStart, fieldEnd - fieldStart);
            if (elementClass == String.class) {
                String stringValue = fragment.asString(true);
                Array.set(array, index++, stringValue);
            } else if (elementClass == Long.class) {
                long longValue = ByteFragmentUtils.parseLong(fragment);
                Array.set(array, index++, longValue);
            } else if (elementClass == Integer.class) {
                int longValue = ByteFragmentUtils.parseInt(fragment);
                Array.set(array, index++, longValue);
            } else if (elementClass == BigInteger.class) {
                BigInteger bigIntegerValue = new BigInteger(fragment.asString(true));
                Array.set(array, index++, bigIntegerValue);
            } else {
                throw new IllegalStateException();
            }
            fieldStart = chIdx + 1;
        }
        return array;
    }

    private static int getArrayLength(ByteFragment value) {
        if (value.length() == 0) {
            return 0;
        }
        int length = 1;
        boolean inQuotation = false;
        for (int i = 0; i < value.length(); ++i) {
            int ch = value.charAt(i);
            if (ch == 92) {
                ++i;
            }
            if ((inQuotation = ch == 39 ^ inQuotation) || ch != 44) continue;
            ++length;
        }
        return length;
    }
}

