/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

public class ClickHouseLZ4OutputStream
extends OutputStream {
    private static final LZ4Factory factory = LZ4Factory.safeInstance();
    private final LittleEndianDataOutputStream dataWrapper;
    private byte[] currentBlock;
    private int pointer;
    private byte[] compressedBlock;
    private final LZ4Compressor compressor;

    public ClickHouseLZ4OutputStream(OutputStream stream, int maxCompressBlockSize) {
        this.dataWrapper = new LittleEndianDataOutputStream(stream);
        this.compressor = factory.fastCompressor();
        this.currentBlock = new byte[maxCompressBlockSize];
        this.compressedBlock = new byte[this.compressor.maxCompressedLength(maxCompressBlockSize)];
    }

    @Override
    public void write(int b) throws IOException {
        this.currentBlock[this.pointer] = (byte)b;
        ++this.pointer;
        if (this.pointer == this.currentBlock.length) {
            this.writeBlock();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.pointer != 0) {
            this.writeBlock();
        }
        this.dataWrapper.flush();
    }

    private void writeBlock() throws IOException {
        int compressed = this.compressor.compress(this.currentBlock, 0, this.pointer, this.compressedBlock, 0);
        byte[] checksum = new byte[16];
        this.dataWrapper.write(checksum);
        this.dataWrapper.writeByte(130);
        this.dataWrapper.writeInt(compressed + 9);
        this.dataWrapper.writeInt(this.pointer);
        this.dataWrapper.write(this.compressedBlock, 0, compressed);
        this.pointer = 0;
    }
}

