/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseExternalData;
import ru.yandex.clickhouse.ClickHousePreparedStatement;
import ru.yandex.clickhouse.ClickHouseStatementImpl;
import ru.yandex.clickhouse.ClickHouseUtil;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.settings.ClickHouseQueryParam;
import ru.yandex.clickhouse.util.ClickHouseArrayUtil;
import ru.yandex.clickhouse.util.guava.StreamUtils;

public class ClickHousePreparedStatementImpl
extends ClickHouseStatementImpl
implements ClickHousePreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseStatementImpl.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String sql;
    private final List<String> sqlParts;
    private String[] binds;
    private boolean[] valuesQuote;
    private List<byte[]> batchRows = new ArrayList<byte[]>();

    public ClickHousePreparedStatementImpl(CloseableHttpClient client, ClickHouseConnection connection, ClickHouseProperties properties, String sql, TimeZone timezone) throws SQLException {
        super(client, connection, properties);
        this.sql = sql;
        this.sqlParts = ClickHousePreparedStatementImpl.parseSql(sql);
        this.createBinds();
        this.initTimeZone(timezone);
    }

    private void createBinds() {
        this.binds = new String[this.sqlParts.size() - 1];
        this.valuesQuote = new boolean[this.sqlParts.size() - 1];
    }

    private void initTimeZone(TimeZone timeZone) {
        this.dateTimeFormat.setTimeZone(timeZone);
        this.dateFormat.setTimeZone(timeZone);
    }

    @Override
    public void clearParameters() {
        Arrays.fill(this.binds, null);
        Arrays.fill(this.valuesQuote, false);
    }

    protected static List<String> parseSql(String sql) throws SQLException {
        if (sql == null) {
            throw new SQLException("sql statement can't be null");
        }
        ArrayList<String> parts = new ArrayList<String>();
        boolean afterBackSlash = false;
        boolean inQuotes = false;
        boolean inBackQuotes = false;
        int partStart = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (afterBackSlash) {
                afterBackSlash = false;
                continue;
            }
            if (c == '\\') {
                afterBackSlash = true;
                continue;
            }
            if (c == '\'') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c == '`') {
                inBackQuotes = !inBackQuotes;
                continue;
            }
            if (c != '?' || inQuotes || inBackQuotes) continue;
            parts.add(sql.substring(partStart, i));
            partStart = i + 1;
        }
        parts.add(sql.substring(partStart, sql.length()));
        return parts;
    }

    protected String buildSql() throws SQLException {
        if (this.sqlParts.size() == 1) {
            return this.sqlParts.get(0);
        }
        ClickHousePreparedStatementImpl.checkBinded(this.binds);
        StringBuilder sb = new StringBuilder(this.sqlParts.get(0));
        for (int i = 1; i < this.sqlParts.size(); ++i) {
            this.appendBoundValue(sb, i - 1);
            sb.append(this.sqlParts.get(i));
        }
        String sql = sb.toString();
        return sql;
    }

    private void appendBoundValue(StringBuilder sb, int num) {
        if (this.valuesQuote[num]) {
            sb.append("'");
        }
        sb.append(this.binds[num]);
        if (this.valuesQuote[num]) {
            sb.append("'");
        }
    }

    private static void checkBinded(String[] binds) throws SQLException {
        for (String b : binds) {
            if (b != null) continue;
            throw new SQLException("Not all parameters binded");
        }
    }

    private byte[] buildBinds() throws SQLException {
        ClickHousePreparedStatementImpl.checkBinded(this.binds);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.binds.length; ++i) {
            sb.append(this.binds[i]);
            sb.append(i < this.binds.length - 1 ? (char)'\t' : '\n');
        }
        return sb.toString().getBytes(StreamUtils.UTF_8);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.buildSql());
    }

    @Override
    public ResultSet executeQuery(Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        return super.executeQuery(this.buildSql(), additionalDBParams);
    }

    @Override
    public ResultSet executeQuery(Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData) throws SQLException {
        return super.executeQuery(this.buildSql(), additionalDBParams, externalData);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.buildSql());
    }

    private void setBind(int parameterIndex, String bind) {
        this.setBind(parameterIndex, bind, false);
    }

    private void setBind(int parameterIndex, String bind, boolean quote) {
        this.binds[parameterIndex - 1] = bind;
        this.valuesQuote[parameterIndex - 1] = quote;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setBind(parameterIndex, "NULL");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setBind(parameterIndex, x ? "1" : "0");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setBind(parameterIndex, Byte.toString(x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setBind(parameterIndex, Short.toString(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setBind(parameterIndex, Integer.toString(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setBind(parameterIndex, Long.toString(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setBind(parameterIndex, Float.toString(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setBind(parameterIndex, Double.toString(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setBind(parameterIndex, x.toPlainString());
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseUtil.escape(x), true);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setBind(parameterIndex, new String(x, StreamUtils.UTF_8));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setBind(parameterIndex, this.dateFormat.format(x), true);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setBind(parameterIndex, this.dateTimeFormat.format(x), true);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Collection collection) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.toString(collection));
    }

    @Override
    public void setArray(int parameterIndex, Object[] array) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.toString(array));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof Byte) {
            this.setInt(parameterIndex, ((Byte)x).intValue());
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x, -1);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof BigInteger) {
            this.setBind(parameterIndex, x.toString());
        } else if (x instanceof Collection) {
            this.setBind(parameterIndex, ClickHouseArrayUtil.toString((Collection)x));
        } else if (x.getClass().isArray()) {
            this.setBind(parameterIndex, ClickHouseArrayUtil.arrayToString(x));
        } else {
            throw new SQLDataException("Can't bind object of class " + x.getClass().getCanonicalName());
        }
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.buildSql());
    }

    @Override
    public void addBatch() throws SQLException {
        this.batchRows.add(this.buildBinds());
        this.createBinds();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int valuePosition = this.sql.toUpperCase().indexOf("VALUES");
        if (valuePosition == -1) {
            throw new SQLSyntaxErrorException("Query must be like 'INSERT INTO [db.]table [(c1, c2, c3)] VALUES (?, ?, ?)'. Got: " + this.sql);
        }
        String insertSql = this.sql.substring(0, valuePosition);
        BatchHttpEntity entity = new BatchHttpEntity(this.batchRows);
        this.sendStream((HttpEntity)entity, insertSql);
        int[] result = new int[this.batchRows.size()];
        Arrays.fill(result, 1);
        this.batchRows = new ArrayList<byte[]>();
        return result;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setBind(parameterIndex, ClickHouseArrayUtil.arrayToString(x.getArray()));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private static class BatchHttpEntity
    extends AbstractHttpEntity {
        private final List<byte[]> rows;

        public BatchHttpEntity(List<byte[]> rows) {
            this.rows = rows;
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            return -1L;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            for (byte[] row : this.rows) {
                outputStream.write(row);
            }
        }

        public boolean isStreaming() {
            return false;
        }
    }
}

