/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import ru.yandex.clickhouse.ClickHouseArray;
import ru.yandex.clickhouse.ClickHouseStatement;
import ru.yandex.clickhouse.except.ClickHouseExceptionSpecifier;
import ru.yandex.clickhouse.response.AbstractResultSet;
import ru.yandex.clickhouse.response.ByteFragment;
import ru.yandex.clickhouse.response.ByteFragmentUtils;
import ru.yandex.clickhouse.response.ClickHouseResultSetMetaData;
import ru.yandex.clickhouse.response.StreamSplitter;
import ru.yandex.clickhouse.util.TypeUtils;

public class ClickHouseResultSet
extends AbstractResultSet {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final StreamSplitter bis;
    private final String db;
    private final String table;
    private final Map<String, Integer> col = new HashMap<String, Integer>();
    private final String[] columns;
    private final String[] types;
    private int maxRows;
    private ByteFragment[] values;
    private int lastReadColumn;
    private ByteFragment nextLine;
    private int rowNumber;
    private Statement statement;

    public ClickHouseResultSet(InputStream is, int bufferSize, String db, String table, ClickHouseStatement statement, TimeZone timezone) throws IOException {
        this.db = db;
        this.table = table;
        this.statement = statement;
        this.initTimeZone(timezone);
        this.bis = new StreamSplitter(is, 10, bufferSize);
        ByteFragment headerFragment = this.bis.next();
        if (headerFragment == null) {
            throw new IllegalArgumentException("ClickHouse response without column names");
        }
        String header = headerFragment.asString(true);
        if (header.startsWith("Code: ") && !header.contains("\t")) {
            is.close();
            throw new IOException("ClickHouse error: " + header);
        }
        this.columns = ClickHouseResultSet.toStringArray(headerFragment);
        ByteFragment typesFragment = this.bis.next();
        if (typesFragment == null) {
            throw new IllegalArgumentException("ClickHouse response without column types");
        }
        this.types = ClickHouseResultSet.toStringArray(typesFragment);
        for (int i = 0; i < this.columns.length; ++i) {
            String s = this.columns[i];
            this.col.put(s, i + 1);
        }
    }

    private void initTimeZone(TimeZone timeZone) {
        this.sdf.setTimeZone(timeZone);
        this.dateFormat.setTimeZone(timeZone);
    }

    private static String[] toStringArray(ByteFragment headerFragment) {
        ByteFragment[] split = headerFragment.split((byte)9);
        String[] c = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            String name;
            c[i] = name = split[i].asString(true);
        }
        return c;
    }

    public boolean hasNext() throws SQLException {
        if (this.nextLine == null) {
            try {
                this.nextLine = this.bis.next();
                if (this.nextLine == null || this.maxRows != 0 && this.rowNumber >= this.maxRows) {
                    this.bis.close();
                    this.nextLine = null;
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        return this.nextLine != null;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.hasNext()) {
            this.values = this.nextLine.split((byte)9);
            this.checkValues(this.columns, this.values, this.nextLine);
            this.nextLine = null;
            ++this.rowNumber;
            return true;
        }
        return false;
    }

    private void checkValues(String[] columns, ByteFragment[] values, ByteFragment fragment) throws SQLException {
        if (columns.length != values.length) {
            throw ClickHouseExceptionSpecifier.specify(fragment.asString());
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.bis.close();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    String[] getTypes() {
        return this.types;
    }

    public String[] getColumnNames() {
        return this.columns;
    }

    public Map<String, Integer> getCol() {
        return this.col;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new ClickHouseResultSetMetaData(this);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.lastReadColumn == 0) {
            throw new IllegalStateException("You should get something before check nullability");
        }
        return this.getValue(this.lastReadColumn).isNull();
    }

    @Override
    public int getInt(String column) {
        return this.getInt(this.asColNum(column));
    }

    @Override
    public boolean getBoolean(String column) {
        return this.getBoolean(this.asColNum(column));
    }

    @Override
    public long getLong(String column) {
        return this.getLong(this.asColNum(column));
    }

    @Override
    public String getString(String column) {
        return this.getString(this.asColNum(column));
    }

    @Override
    public byte[] getBytes(String column) {
        return this.getBytes(this.asColNum(column));
    }

    public Long getTimestampAsLong(String column) {
        return this.getTimestampAsLong(this.asColNum(column));
    }

    @Override
    public Timestamp getTimestamp(String column) throws SQLException {
        Long value = this.getTimestampAsLong(column);
        return value == null ? null : new Timestamp(value);
    }

    @Override
    public short getShort(String column) {
        return this.getShort(this.asColNum(column));
    }

    @Override
    public byte getByte(String column) {
        return this.getByte(this.asColNum(column));
    }

    @Override
    public long[] getLongArray(String column) {
        return this.getLongArray(this.asColNum(column));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        if (TypeUtils.toSqlType(this.types[columnIndex - 1]) != 2003) {
            throw new SQLException("Not an array");
        }
        String elementTypeName = TypeUtils.getArrayElementTypeName(this.types[columnIndex - 1]);
        int elementType = TypeUtils.toSqlType(elementTypeName);
        boolean isUnsigned = TypeUtils.isUnsigned(elementTypeName);
        Object array = ByteFragmentUtils.parseArray(this.getValue(columnIndex), TypeUtils.toClass(elementType, isUnsigned));
        return new ClickHouseArray(elementType, isUnsigned, array);
    }

    @Override
    public Array getArray(String column) throws SQLException {
        return this.getArray(this.asColNum(column));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.asColNum(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.asColNum(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.asColNum(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.asColNum(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.asColNum(columnLabel));
    }

    @Override
    public String getString(int colNum) {
        return ClickHouseResultSet.toString(this.getValue(colNum));
    }

    @Override
    public int getInt(int colNum) {
        return ByteFragmentUtils.parseInt(this.getValue(colNum));
    }

    @Override
    public boolean getBoolean(int colNum) {
        return ClickHouseResultSet.toBoolean(this.getValue(colNum));
    }

    @Override
    public long getLong(int colNum) {
        return ByteFragmentUtils.parseLong(this.getValue(colNum));
    }

    @Override
    public byte[] getBytes(int colNum) {
        return ClickHouseResultSet.toBytes(this.getValue(colNum));
    }

    public Long getTimestampAsLong(int colNum) {
        return this.toTimestamp(this.getValue(colNum));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Long value = this.getTimestampAsLong(columnIndex);
        return value == null ? null : new Timestamp(value);
    }

    @Override
    public short getShort(int colNum) {
        return ClickHouseResultSet.toShort(this.getValue(colNum));
    }

    @Override
    public byte getByte(int colNum) {
        return ClickHouseResultSet.toByte(this.getValue(colNum));
    }

    public long[] getLongArray(int colNum) {
        return ClickHouseResultSet.toLongArray(this.getValue(colNum));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return (float)this.getDouble(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String string = this.getString(columnIndex);
        if (string == null) {
            return 0.0;
        }
        if (string.equals("nan")) {
            return Double.NaN;
        }
        if (string.equals("+inf") || string.equals("inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(string);
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        ByteFragment value = this.getValue(columnIndex);
        if (value.isNull()) {
            return null;
        }
        try {
            return new Date(this.dateFormat.parse(value.asString()).getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return new Time(this.getTimestamp(columnIndex).getTime());
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            String typeName = this.types[columnIndex - 1];
            int type = TypeUtils.toSqlType(typeName);
            switch (type) {
                case -5: {
                    if (TypeUtils.isUnsigned(typeName)) {
                        String stringVal = this.getString(columnIndex);
                        return new BigInteger(stringVal);
                    }
                    return this.getLong(columnIndex);
                }
                case 4: {
                    if (TypeUtils.isUnsigned(typeName)) {
                        return this.getLong(columnIndex);
                    }
                    return this.getInt(columnIndex);
                }
                case 12: {
                    return this.getString(columnIndex);
                }
                case 6: {
                    return Float.valueOf(this.getFloat(columnIndex));
                }
                case 91: {
                    return this.getDate(columnIndex);
                }
                case 93: {
                    return this.getTimestamp(columnIndex);
                }
                case 2004: {
                    return this.getString(columnIndex);
                }
                case 2003: {
                    return this.getArray(columnIndex).getArray();
                }
            }
            return this.getString(columnIndex);
        }
        catch (Exception e) {
            throw new RuntimeException("Parse exception: " + this.values[columnIndex - 1].toString(), e);
        }
    }

    private static byte toByte(ByteFragment value) {
        return Byte.parseByte(value.asString());
    }

    private static short toShort(ByteFragment value) {
        if (value.isNull()) {
            return 0;
        }
        return Short.parseShort(value.asString());
    }

    private static boolean toBoolean(ByteFragment value) {
        if (value.isNull()) {
            return false;
        }
        return "1".equals(value.asString());
    }

    private static byte[] toBytes(ByteFragment value) {
        if (value.isNull()) {
            return null;
        }
        return value.unescape();
    }

    private static String toString(ByteFragment value) {
        return value.asString(true);
    }

    private static long[] toLongArray(ByteFragment value) {
        if (value.isNull()) {
            return null;
        }
        if (value.charAt(0) != 91 || value.charAt(value.length() - 1) != 93) {
            throw new IllegalArgumentException("not an array: " + value);
        }
        ByteFragment trim = value.subseq(1, value.length() - 2);
        ByteFragment[] values = trim.split((byte)44);
        long[] result = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = ByteFragmentUtils.parseLong(values[i]);
        }
        return result;
    }

    private Long toTimestamp(ByteFragment value) {
        if (value.isNull()) {
            return null;
        }
        try {
            return this.sdf.parse(value.asString()).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowNumber + 1;
    }

    public String getDb() {
        return this.db;
    }

    public String getTable() {
        return this.table;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    private int asColNum(String column) {
        if (this.col.containsKey(column)) {
            return this.col.get(column);
        }
        throw new RuntimeException("no column " + column + " in columns list " + Arrays.toString(this.getColumnNames()));
    }

    private ByteFragment getValue(int colNum) {
        this.lastReadColumn = colNum;
        return this.values[colNum - 1];
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.asColNum(columnLabel), type);
    }

    public ByteFragment[] getValues() {
        return this.values;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) {
        return this.getBigDecimal(this.asColNum(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        String string = this.getString(columnIndex);
        if (string == null) {
            return null;
        }
        return new BigDecimal(string);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) {
        return this.getBigDecimal(this.asColNum(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) {
        String string = this.getString(columnIndex);
        if (string == null) {
            return null;
        }
        BigDecimal result = new BigDecimal(string);
        return result.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    public String toString() {
        return "ClickHouseResultSet{sdf=" + this.sdf + ", dateFormat=" + this.dateFormat + ", bis=" + this.bis + ", db='" + this.db + '\'' + ", table='" + this.table + '\'' + ", col=" + this.col + ", columns=" + Arrays.toString(this.columns) + ", types=" + Arrays.toString(this.types) + ", maxRows=" + this.maxRows + ", values=" + Arrays.toString(this.values) + ", lastReadColumn=" + this.lastReadColumn + ", nextLine=" + this.nextLine + ", rowNumber=" + this.rowNumber + ", statement=" + this.statement + '}';
    }
}

