/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import com.google.common.base.Preconditions;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class ClickHouseRowBinaryStream {
    private static final int U_INT8_MAX = 255;
    private static final int U_INT16_MAX = 65535;
    private static final long U_INT32_MAX = 0xFFFFFFFFL;
    private final LittleEndianDataOutputStream out;
    private final DateTimeZone dateTimeZone;
    private final LocalDate epochDate;

    public ClickHouseRowBinaryStream(OutputStream outputStream, TimeZone timeZone) {
        this.out = new LittleEndianDataOutputStream(outputStream);
        this.dateTimeZone = DateTimeZone.forTimeZone((TimeZone)timeZone);
        this.epochDate = new LocalDate(0L, this.dateTimeZone);
    }

    public void writeUnsignedLeb128(int value) throws IOException {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0);
        for (int remaining = value >>> 7; remaining != 0; remaining >>>= 7) {
            this.out.write((int)((byte)(value & 0x7F | 0x80)));
            value = remaining;
        }
        this.out.write((int)((byte)(value & 0x7F)));
    }

    public void writeString(String string) throws IOException {
        Preconditions.checkNotNull((Object)string);
        byte[] bytes = string.getBytes();
        this.writeUnsignedLeb128(bytes.length);
        this.out.write(bytes);
    }

    private void validateInt(int value, int minValue, int maxValue, String dataType) {
        if (value < minValue || value > maxValue) {
            throw new IllegalStateException("Not a " + dataType + " value: " + value);
        }
    }

    public void writeUInt8(boolean value) throws IOException {
        this.out.writeByte(value ? 1 : 0);
    }

    public void writeUInt8(int value) throws IOException {
        this.validateInt(value, 0, 255, "UInt8");
        byte unsigned = (byte)((long)value & 0xFFL);
        this.out.writeByte((int)unsigned);
    }

    public void writeInt8(int value) throws IOException {
        this.validateInt(value, -128, 127, "Int8");
        this.out.writeByte(value);
    }

    public void writeInt8(byte value) throws IOException {
        this.out.writeByte((int)value);
    }

    public void writeInt16(int value) throws IOException {
        this.validateInt(value, Short.MIN_VALUE, Short.MAX_VALUE, "Int6");
        this.out.writeShort(value);
    }

    public void writeInt16(short value) throws IOException {
        this.out.writeShort((int)value);
    }

    public void writeUInt16(int value) throws IOException {
        this.validateInt(value, 0, 65535, "UInt16");
        short unsigned = (short)((long)value & 0xFFFFL);
        this.out.writeShort((int)unsigned);
    }

    public void writeInt32(int value) throws IOException {
        this.out.writeInt(value);
    }

    public void writeUInt32(long value) throws IOException {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalStateException("Not a UInt32 value: " + value);
        }
        int unsigned = (int)(value & 0xFFFFFFFFL);
        this.out.writeInt(unsigned);
    }

    public void writeInt64(long value) throws IOException {
        this.out.writeLong(value);
    }

    public void writeUInt64(long value) throws IOException {
        if (value < 0L) {
            throw new IllegalStateException("Not a UInt64 value: " + value);
        }
        this.out.writeLong(value);
    }

    public void writeUInt64(UnsignedLong value) throws IOException {
        this.out.writeLong(value.longValue());
    }

    public void writeDateTime(Date date) throws IOException {
        Preconditions.checkNotNull((Object)date);
        this.writeUInt32(TimeUnit.MILLISECONDS.toSeconds(date.getTime()));
    }

    public void writeDate(LocalDate date) throws IOException {
        Preconditions.checkNotNull((Object)date);
        int daysSinceEpoch = Days.daysBetween((ReadablePartial)this.epochDate, (ReadablePartial)date).getDays();
        this.writeUInt16(daysSinceEpoch);
    }

    public void writeDate(Date date) throws IOException {
        Preconditions.checkNotNull((Object)date);
        LocalDate localDate = new LocalDate(date.getTime(), this.dateTimeZone);
        int daysSinceEpoch = Days.daysBetween((ReadablePartial)this.epochDate, (ReadablePartial)localDate).getDays();
        this.writeUInt16(daysSinceEpoch);
    }

    public void writeFloat32(float value) throws IOException {
        this.out.writeFloat(value);
    }

    public void writeFloat64(double value) throws IOException {
        this.out.writeDouble(value);
    }
}

