/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import ru.yandex.clickhouse.ClickHouseDriver;
import ru.yandex.clickhouse.settings.ClickHouseProperties;

public class ClickHouseDataSource
implements DataSource {
    protected static final Pattern urlRegexp = Pattern.compile("^jdbc:clickhouse://([a-zA-Z0-9.-]+):([0-9]+)(?:|/|/([a-zA-Z0-9_]+))$");
    protected static final String DEFAULT_DATABASE = "default";
    protected final ClickHouseDriver driver = new ClickHouseDriver();
    protected final String url;
    protected String host;
    protected int port;
    protected String database;
    PrintWriter printWriter;
    protected int loginTimeout = 0;
    private ClickHouseProperties properties;

    public ClickHouseDataSource(String url) {
        this(url, new ClickHouseProperties());
    }

    public ClickHouseDataSource(String url, Properties info) {
        this(url, new ClickHouseProperties(info));
    }

    public ClickHouseDataSource(String url, ClickHouseProperties properties) {
        if (url == null) {
            throw new IllegalArgumentException("Incorrect ClickHouse jdbc url: " + url);
        }
        this.url = url;
        Matcher m = urlRegexp.matcher(url);
        if (m.find()) {
            this.host = m.group(1);
            this.port = Integer.parseInt(m.group(2));
            this.database = m.group(3) != null ? m.group(3) : DEFAULT_DATABASE;
        } else {
            throw new IllegalArgumentException("Incorrect ClickHouse jdbc url: " + url);
        }
        this.properties = new ClickHouseProperties(properties);
        this.properties.setDatabase(this.database);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.driver.connect(this.url, this.properties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.driver.connect(this.url, this.properties.withCredentials(username, password));
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public ClickHouseDataSource withConnectionsCleaning(int rate, TimeUnit timeUnit) {
        this.driver.scheduleConnectionsCleaning(rate, timeUnit);
        return this;
    }
}

